/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.Objects;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.readconfig.ReadConfig;

public final class EnvironmentalDatabaseConnectionSourceBuilder {
    private static final String JDBC_URL = "SCHCRWLR_JDBC_URL";
    private static final String SERVER = "SCHCRWLR_SERVER";
    private static final String DATABASE = "SCHCRWLR_DATABASE";
    private static final String HOST = "SCHCRWLR_HOST";
    private static final String PORT = "SCHCRWLR_PORT";
    private static final String DATABASE_USER = "SCHCRWLR_DATABASE_USER";
    private static final String DATABASE_PASSWORD = "SCHCRWLR_DATABASE_PASSWORD";

    public static DatabaseConnectionSourceBuilder builder() {
        return EnvironmentalDatabaseConnectionSourceBuilder.builder(System::getenv);
    }

    public static DatabaseConnectionSourceBuilder builder(ReadConfig config) {
        Objects.requireNonNull(config, "No environmental accessor provided");
        String connectionUrl = Utility.trimToEmpty(config.getStringValue(JDBC_URL));
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = !Utility.isBlank(connectionUrl) ? EnvironmentalDatabaseConnectionSourceBuilder.builderFromUrl(connectionUrl) : EnvironmentalDatabaseConnectionSourceBuilder.builderForServer(config);
        MultiUseUserCredentials userCredentials = new MultiUseUserCredentials(Utility.trimToEmpty(config.getStringValue(DATABASE_USER)), config.getStringValue(DATABASE_PASSWORD, null));
        dbConnectionSourceBuilder.withUserCredentials(userCredentials);
        return dbConnectionSourceBuilder;
    }

    private static DatabaseConnectionSourceBuilder builderForServer(ReadConfig config) {
        String databaseSystemIdentifier = Utility.trimToEmpty(config.getStringValue(SERVER));
        DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector databaseConnector = databaseConnectorRegistry.findDatabaseConnectorFromDatabaseSystemIdentifier(databaseSystemIdentifier);
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = databaseConnector.databaseConnectionSourceBuilder();
        String host = Utility.trimToEmpty(config.getStringValue(HOST));
        dbConnectionSourceBuilder.withHost(host);
        String port = Utility.trimToEmpty(config.getStringValue(PORT));
        if (EnvironmentalDatabaseConnectionSourceBuilder.isValidPort(port)) {
            dbConnectionSourceBuilder.withPort(Integer.valueOf(port));
        }
        String database = Utility.trimToEmpty(config.getStringValue(DATABASE));
        dbConnectionSourceBuilder.withDatabase(database);
        return dbConnectionSourceBuilder;
    }

    private static DatabaseConnectionSourceBuilder builderFromUrl(String connectionUrl) {
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = DatabaseConnectionSourceBuilder.builder(connectionUrl);
        DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector databaseConnector = databaseConnectorRegistry.findDatabaseConnectorFromUrl(connectionUrl);
        dbConnectionSourceBuilder.withConnectionInitializer(databaseConnector.databaseConnectionSourceBuilder().getConnectionInitializer());
        return dbConnectionSourceBuilder;
    }

    private static boolean isValidPort(String value) {
        if (Utility.isBlank(value)) {
            return false;
        }
        try {
            int port = Integer.parseInt(value);
            return port > 1023 && port < 65536;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private EnvironmentalDatabaseConnectionSourceBuilder() {
    }
}

