/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.connection;

import com.jetbrains.fus.reporting.model.http.HttpRequest;
import com.jetbrains.fus.reporting.model.http.HttpRequestBuilder;
import com.jetbrains.fus.reporting.model.http.Method;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u001a\u0010\f\u001a\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0005R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/fus/reporting/connection/JavaHttpRequestBuilder;", "Lcom/jetbrains/fus/reporting/model/http/HttpRequestBuilder;", "()V", "extraHeaders", "", "", "timeout", "Ljava/time/Duration;", "userAgent", "newGetRequest", "Lcom/jetbrains/fus/reporting/model/http/HttpRequest;", "url", "setExtraHeaders", "setTimeout", "duration", "setUserAgent", "Companion", "connection-client"})
public final class JavaHttpRequestBuilder
implements HttpRequestBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String userAgent;
    @Nullable
    private Map<String, String> extraHeaders;
    @NotNull
    private Duration timeout;

    public JavaHttpRequestBuilder() {
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(10)");
        this.timeout = duration;
    }

    @NotNull
    public final JavaHttpRequestBuilder setUserAgent(@NotNull String userAgent) {
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        this.userAgent = userAgent;
        return this;
    }

    @NotNull
    public final JavaHttpRequestBuilder setExtraHeaders(@NotNull Map<String, String> extraHeaders) {
        Intrinsics.checkNotNullParameter(extraHeaders, (String)"extraHeaders");
        this.extraHeaders = extraHeaders;
        return this;
    }

    @NotNull
    public final JavaHttpRequestBuilder setTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.timeout = duration;
        return this;
    }

    public static /* synthetic */ JavaHttpRequestBuilder setTimeout$default(JavaHttpRequestBuilder javaHttpRequestBuilder, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(10)");
            duration = duration2;
        }
        return javaHttpRequestBuilder.setTimeout(duration);
    }

    @Override
    @NotNull
    public HttpRequest newGetRequest(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new HttpRequest(this, url){
            @Nullable
            private final String userAgent;
            @Nullable
            private final Map<String, String> extraHeaders;
            @NotNull
            private final Duration timeout;
            @NotNull
            private final Method method;
            @NotNull
            private final String url;
            {
                this.userAgent = JavaHttpRequestBuilder.access$getUserAgent$p($receiver);
                this.extraHeaders = JavaHttpRequestBuilder.access$getExtraHeaders$p($receiver);
                this.timeout = JavaHttpRequestBuilder.access$getTimeout$p($receiver);
                this.method = Method.GET;
                this.url = $url;
            }

            @Nullable
            public String getUserAgent() {
                return this.userAgent;
            }

            @Nullable
            public Map<String, String> getExtraHeaders() {
                return this.extraHeaders;
            }

            @NotNull
            public Duration getTimeout() {
                return this.timeout;
            }

            @NotNull
            public Method getMethod() {
                return this.method;
            }

            @NotNull
            public String getUrl() {
                return this.url;
            }
        };
    }

    public static final /* synthetic */ String access$getUserAgent$p(JavaHttpRequestBuilder $this) {
        return $this.userAgent;
    }

    public static final /* synthetic */ Map access$getExtraHeaders$p(JavaHttpRequestBuilder $this) {
        return $this.extraHeaders;
    }

    public static final /* synthetic */ Duration access$getTimeout$p(JavaHttpRequestBuilder $this) {
        return $this.timeout;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/fus/reporting/connection/JavaHttpRequestBuilder$Companion;", "", "()V", "newJavaGetHttpRequest", "Ljava/net/http/HttpRequest;", "httpRequest", "Lcom/jetbrains/fus/reporting/model/http/HttpRequest;", "connection-client"})
    @SourceDebugExtension(value={"SMAP\nJavaHttpRequestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaHttpRequestBuilder.kt\ncom/jetbrains/fus/reporting/connection/JavaHttpRequestBuilder$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,52:1\n215#2,2:53\n*S KotlinDebug\n*F\n+ 1 JavaHttpRequestBuilder.kt\ncom/jetbrains/fus/reporting/connection/JavaHttpRequestBuilder$Companion\n*L\n46#1:53,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final java.net.http.HttpRequest newJavaGetHttpRequest(@NotNull HttpRequest httpRequest) {
            Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
            HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().timeout(httpRequest.getTimeout());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder().timeout(httpRequest.timeout)");
            HttpRequest.Builder builder2 = builder;
            if (httpRequest.getUserAgent() != null) {
                builder2.setHeader("User-Agent", httpRequest.getUserAgent());
            }
            Map<String, String> map2 = httpRequest.getExtraHeaders();
            if (map2 != null) {
                Map<String, String> $this$forEach$iv = map2;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    String k = entry.getKey();
                    String v = entry.getValue();
                    builder2.setHeader(k, v);
                }
            }
            builder2.uri(URI.create(httpRequest.getUrl()));
            builder2.GET();
            java.net.http.HttpRequest httpRequest2 = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequest2, (String)"builder.build()");
            return httpRequest2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

