/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.combined.CombinedDiffKeysKt;
import com.intellij.diff.tools.combined.CombinedDiffManager;
import com.intellij.diff.tools.combined.CombinedDiffRegistry;
import com.intellij.diff.util.CombinedDiffToggle;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.Side;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.ui.frame.ComponentQuickActionProvider;
import com.intellij.vcs.log.ui.frame.VcsLogAsyncChangesTreeModel;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesTreeComponents;
import com.intellij.vcs.log.ui.frame.VcsLogDiffPreviewHandler;
import com.intellij.vcs.log.ui.frame.VcsLogTreeChangeProcessorTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010-J\u0010\u0010.\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u000200R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesBrowserBase;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel;", "parent", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel;Lcom/intellij/openapi/Disposable;)V", "toolbarWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "createToolbarComponent", "Ljavax/swing/JComponent;", "createCenterPanel", "setToolbarHeightReferent", "", "referent", "createToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createLastToolbarActions", "createPopupMenuActions", "changesTreeModel", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTreeModel;", "getChangesTreeModel", "()Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTreeModel;", "dispose", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "userObject", "", "forDiffPreview", "", "createChangeProcessor", "Lcom/intellij/diff/impl/DiffEditorViewer;", "isInEditor", "selectChange", "tag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "selectFile", "toSelect", "Lcom/intellij/openapi/vcs/FilePath;", "getTag", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class VcsLogChangesBrowser
extends AsyncChangesBrowserBase
implements Disposable {
    @NotNull
    private final VcsLogAsyncChangesTreeModel model;
    @NotNull
    private final Wrapper toolbarWrapper;

    public VcsLogChangesBrowser(@NotNull Project project, @NotNull VcsLogAsyncChangesTreeModel model, @NotNull Disposable parent) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, false, false);
        this.model = model;
        Disposer.register((Disposable)parent, (Disposable)this);
        JComponent toolbarComponent = jComponent = this.getToolbar().getComponent();
        boolean bl = false;
        this.toolbarWrapper = new Wrapper(toolbarComponent);
        GuiUtils.installVisibilityReferent((JComponent)((JComponent)this.toolbarWrapper), (JComponent)toolbarComponent);
        this.init();
        this.hideViewerBorder();
        JScrollPane jScrollPane = this.getViewerScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getViewerScrollPane(...)");
        ScrollableContentBorder.Companion.setup$default((ScrollableContentBorder.Companion)ScrollableContentBorder.Companion, (JScrollPane)jScrollPane, (Side)Side.TOP, null, (int)4, null);
        this.getAccessibleContext().setAccessibleName(VcsLogBundle.message("vcs.log.changes.accessible.name", new Object[0]));
        this.myViewer.setEmptyText(VcsLogBundle.message("vcs.log.changes.select.commits.to.view.changes.status", new Object[0]));
        this.myViewer.rebuildTree();
        this.model.addListener(this, () -> VcsLogChangesBrowser._init_$lambda$1(this));
    }

    @NotNull
    protected JComponent createToolbarComponent() {
        return (JComponent)this.toolbarWrapper;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent jComponent = super.createCenterPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createCenterPanel(...)");
        JComponent centerPanel = jComponent;
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)centerPanel, JScrollPane.class);
        if (scrollPane != null) {
            ClientProperty.put((JComponent)scrollPane, (Key)UIUtil.KEEP_BORDER_SIDES, (Object)2);
        }
        return centerPanel;
    }

    public final void setToolbarHeightReferent(@NotNull JComponent referent) {
        Intrinsics.checkNotNullParameter((Object)referent, (String)"referent");
        this.toolbarWrapper.setVerticalSizeReferent(referent);
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        Object[] objectArray = new AnAction[]{CustomActionsSchema.Companion.getInstance().getCorrectedAction("Vcs.Log.ChangesBrowser.Toolbar")};
        List list = ContainerUtil.append((List)super.createToolbarActions(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"append(...)");
        return list;
    }

    @NotNull
    protected List<AnAction> createLastToolbarActions() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        Object[] objectArray = new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Popup")};
        List list = ContainerUtil.append((List)super.createPopupMenuActions(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"append(...)");
        return list;
    }

    @NotNull
    protected AsyncChangesTreeModel getChangesTreeModel() {
        return (AsyncChangesTreeModel)this.model;
    }

    public void dispose() {
        this.shutdown();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        DataKey dataKey = QuickActionProvider.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"KEY");
        sink.set(dataKey, (Object)new ComponentQuickActionProvider((JComponent)((Object)this)));
        VcsLogChangesTreeComponents.INSTANCE.uiDataSnapshot(sink, this.model, this.getViewer());
    }

    @Nullable
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        return this.getDiffRequestProducer(userObject, false);
    }

    @Nullable
    public final ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject, boolean forDiffPreview) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        if (!(userObject instanceof Change)) {
            return null;
        }
        Map context = new HashMap();
        if (!(userObject instanceof MergedChange)) {
            ChangesBrowserNode.Tag tag = this.getTag((Change)userObject);
            if (tag != null) {
                ChangesBrowserNode.Tag tag2 = tag;
                boolean bl = false;
                context.put(ChangeDiffRequestProducer.TAG_KEY, tag2);
            }
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return VcsLogAsyncChangesTreeModel.Companion.createDiffRequestProducer(project, (Change)userObject, context);
    }

    @NotNull
    public final DiffEditorViewer createChangeProcessor(boolean isInEditor) {
        String place = isInEditor ? "Default" : "VcsLogView";
        VcsLogDiffPreviewHandler handler = new VcsLogDiffPreviewHandler(this);
        DiffEditorViewer processor = null;
        if (CombinedDiffRegistry.INSTANCE.isEnabled()) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            processor = (DiffEditorViewer)CombinedDiffManager.Companion.getInstance(project).createProcessor(place);
            processor.getContext().putUserData(CombinedDiffKeysKt.getDISABLE_LOADING_BLOCKS(), (Object)true);
        } else {
            processor = (DiffEditorViewer)new VcsLogChangeProcessor(place, this.getViewer(), handler, true);
        }
        new VcsLogTreeChangeProcessorTracker(this.getViewer(), processor, handler, !isInEditor).track();
        processor.getContext().putUserData(DiffUserDataKeysEx.COMBINED_DIFF_TOGGLE, (Object)CombinedDiffToggle.Companion.getDEFAULT());
        return processor;
    }

    public final void selectChange(@NotNull Object userObject, @Nullable ChangesBrowserNode.Tag tag) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        this.getViewer().invokeAfterRefresh(() -> VcsLogChangesBrowser.selectChange$lambda$0(this, userObject, tag));
    }

    public final void selectFile(@Nullable FilePath toSelect) {
        this.getViewer().invokeAfterRefresh(() -> VcsLogChangesBrowser.selectFile$lambda$0(this, toSelect));
    }

    @Nullable
    public final ChangesBrowserNode.Tag getTag(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return VcsLogChangesTreeComponents.INSTANCE.getTag(this.model, change);
    }

    private static final void _init_$lambda$1(VcsLogChangesBrowser this$0) {
        this$0.getViewer().requestRefresh(() -> VcsLogChangesBrowser.lambda$1$0(this$0));
    }

    private static final void lambda$1$0(VcsLogChangesBrowser this$0) {
        VcsLogAsyncChangesTreeModel vcsLogAsyncChangesTreeModel = this$0.model;
        StatusText statusText2 = this$0.getViewer().getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"getEmptyText(...)");
        VcsLogChangesTreeComponents.INSTANCE.updateStatusText(vcsLogAsyncChangesTreeModel, statusText2);
    }

    private static final void selectChange$lambda$0(VcsLogChangesBrowser this$0, Object $userObject, ChangesBrowserNode.Tag $tag) {
        ChangesBrowserBase.selectObjectWithTag((ChangesTree)this$0.myViewer, (Object)$userObject, (ChangesBrowserNode.Tag)$tag);
    }

    private static final void selectFile$lambda$0(VcsLogChangesBrowser this$0, FilePath $toSelect) {
        this$0.getViewer().selectFile($toSelect);
    }
}

