/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportedModuleType
implements PyType {
    @NotNull
    private final PyImportedModule myImportedModule;

    public PyImportedModuleType(@NotNull PyImportedModule importedModule) {
        if (importedModule == null) {
            PyImportedModuleType.$$$reportNull$$$0(0);
        }
        this.myImportedModule = importedModule;
    }

    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PsiFileSystemItem resolvedModuleOrPackage;
        if (name == null) {
            PyImportedModuleType.$$$reportNull$$$0(1);
        }
        if (direction == null) {
            PyImportedModuleType.$$$reportNull$$$0(2);
        }
        if (resolveContext == null) {
            PyImportedModuleType.$$$reportNull$$$0(3);
        }
        List<PsiElement> importedModuleCandidates = ResolveResultList.getElements(this.myImportedModule.multiResolve());
        SmartList primaryResults = new SmartList();
        for (PsiElement moduleLocation : importedModuleCandidates) {
            List<? extends RatedResolveResult> results;
            resolvedModuleOrPackage = PyUtil.as(moduleLocation, PsiFileSystemItem.class);
            if (resolvedModuleOrPackage == null || (results = PyModuleType.resolveMemberInPackageOrModule(this.myImportedModule, resolvedModuleOrPackage, name, (PsiElement)location, resolveContext)) == null) continue;
            primaryResults.addAll(results);
        }
        if (!primaryResults.isEmpty()) {
            return PyUtil.filterTopPriorityResults(primaryResults);
        }
        for (PsiElement moduleLocation : importedModuleCandidates) {
            resolvedModuleOrPackage = PyUtil.as(moduleLocation, PsiFileSystemItem.class);
            if (resolvedModuleOrPackage == null || this.myImportedModule.getImportElement() != null) continue;
            PsiFile resolvingFromFile = location != null ? location.getContainingFile() : null;
            List<RatedResolveResult> fallbackResults = ResolveImportUtil.resolveChildren((PsiElement)resolvedModuleOrPackage, name, resolvingFromFile, false, true, false, false);
            return ResolveResultList.asImportedResults(fallbackResults, null);
        }
        return null;
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiElement resolveResult : ResolveResultList.getElements(this.myImportedModule.multiResolve())) {
            PsiDirectory dir;
            if (resolveResult instanceof PyFile) {
                PyModuleType moduleType = new PyModuleType((PyFile)resolveResult);
                TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)location.getProject(), (PsiFile)location.getContainingFile());
                result.addAll(moduleType.getCompletionVariantsAsLookupElements(location, context, false, false, typeEvalContext));
                continue;
            }
            if (!(resolveResult instanceof PsiDirectory) || !PyUtil.isPackage(dir = (PsiDirectory)resolveResult, location)) continue;
            if (ResolveImportUtil.getPointInImport(location) != PointInImport.NONE) {
                result.addAll(PyModuleType.getSubModuleVariants(dir, location, null));
                continue;
            }
            result.addAll(PyModuleType.collectImportedSubmodulesAsLookupElements((PsiFileSystemItem)dir, location, (Set)context.get(CTX_NAMES)));
        }
        return ArrayUtil.toObjectArray(result);
    }

    public String getName() {
        return this.myImportedModule.getImportedPrefix().toString();
    }

    public boolean isBuiltin() {
        return false;
    }

    public void assertValid(String message) {
    }

    @NotNull
    public PyImportedModule getImportedModule() {
        PyImportedModule pyImportedModule = this.myImportedModule;
        if (pyImportedModule == null) {
            PyImportedModuleType.$$$reportNull$$$0(4);
        }
        return pyImportedModule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyImportedModuleType type = (PyImportedModuleType)o;
        return Objects.equals((Object)this.myImportedModule, (Object)type.myImportedModule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myImportedModule});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyImportedModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyImportedModuleType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

