/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.toolbox;

import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public class Maybe<T> {
    private final boolean myIsDefined;
    private final T myValue;

    public boolean isDefined() {
        return this.myIsDefined;
    }

    @Nullable
    public T valueOrNull() {
        if (this.myIsDefined) {
            return this.myValue;
        }
        return null;
    }

    public T value() {
        if (this.myIsDefined) {
            return this.myValue;
        }
        throw new NoSuchElementException("Accessing undefined value of Maybe");
    }

    public Maybe(T value) {
        this.myValue = value;
        this.myIsDefined = true;
    }

    public Maybe() {
        this.myValue = null;
        this.myIsDefined = false;
    }

    public String toString() {
        if (this.myIsDefined) {
            if (this.myValue == null) {
                return "?(null)";
            }
            return "?(" + this.myValue.toString() + ")";
        }
        return "?_";
    }
}

