/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import lombok.Generated;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.sql.opensearch.request.AggregateAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.FilterParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;

public class AggregateFilterAnalyzer {
    private final AggregateAnalyzer.AggregateBuilderHelper helper;
    private final Project project;

    public Pair<AggregationBuilder, MetricParser> analyze(Pair<AggregationBuilder, MetricParser> aggResult, AggregateCall aggCall, String aggName) throws PredicateAnalyzer.ExpressionNotAnalyzableException {
        if (this.project == null || !aggCall.hasFilter()) {
            return aggResult;
        }
        PredicateAnalyzer.QueryExpression queryExpression = this.analyzeAggregateFilter(aggCall);
        return Pair.of((Object)this.buildFilterAggregation((AggregationBuilder)aggResult.getLeft(), aggName, queryExpression), (Object)this.buildFilterParser((MetricParser)aggResult.getRight(), aggName));
    }

    private PredicateAnalyzer.QueryExpression analyzeAggregateFilter(AggregateCall aggCall) throws PredicateAnalyzer.ExpressionNotAnalyzableException {
        RexNode filterCondition = (RexNode)this.project.getProjects().get(aggCall.filterArg);
        return PredicateAnalyzer.analyzeExpression(filterCondition, this.helper.rowType.getFieldNames(), this.helper.fieldTypes, this.helper.rowType, this.helper.cluster);
    }

    private AggregationBuilder buildFilterAggregation(AggregationBuilder aggBuilder, String aggName, PredicateAnalyzer.QueryExpression queryExpression) {
        return AggregationBuilders.filter((String)aggName, (QueryBuilder)queryExpression.builder()).subAggregation(aggBuilder);
    }

    private MetricParser buildFilterParser(MetricParser aggParser, String aggName) {
        return FilterParser.builder().name(aggName).metricsParser(aggParser).build();
    }

    @Generated
    public AggregateFilterAnalyzer(AggregateAnalyzer.AggregateBuilderHelper helper, Project project) {
        this.helper = helper;
        this.project = project;
    }
}

