/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.MatchBehavior;
import org.passay.PasswordData;
import org.passay.PasswordUtils;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultMetadata;

public class IllegalCharacterRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_CHAR";
    protected boolean reportAllFailures;
    private final char[] illegalCharacters;
    private final MatchBehavior matchBehavior;

    public IllegalCharacterRule(char[] c) {
        this(c, MatchBehavior.Contains, true);
    }

    public IllegalCharacterRule(char[] c, MatchBehavior behavior) {
        this(c, behavior, true);
    }

    public IllegalCharacterRule(char[] c, boolean reportAll) {
        this(c, MatchBehavior.Contains, reportAll);
    }

    public IllegalCharacterRule(char[] c, MatchBehavior behavior, boolean reportAll) {
        if (c.length <= 0) {
            throw new IllegalArgumentException("illegal characters length must be greater than zero");
        }
        this.illegalCharacters = c;
        this.matchBehavior = behavior;
        this.reportAllFailures = reportAll;
    }

    public char[] getIllegalCharacters() {
        return this.illegalCharacters;
    }

    public MatchBehavior getMatchBehavior() {
        return this.matchBehavior;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        HashSet<Character> matches = new HashSet<Character>();
        String text = passwordData.getPassword();
        for (char c : this.illegalCharacters) {
            if (!this.matchBehavior.match(text, c) || matches.contains(Character.valueOf(c))) continue;
            String[] codes = new String[]{"ILLEGAL_CHAR." + c, "ILLEGAL_CHAR." + this.matchBehavior.upperSnakeName(), ERROR_CODE};
            result.addError(codes, this.createRuleResultDetailParameters(c));
            if (!this.reportAllFailures) break;
            matches.add(Character.valueOf(c));
        }
        result.setMetadata(this.createRuleResultMetadata(passwordData));
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("illegalCharacter", Character.valueOf(c));
        m.put("matchBehavior", (Object)this.matchBehavior);
        return m;
    }

    protected RuleResultMetadata createRuleResultMetadata(PasswordData password) {
        return new RuleResultMetadata(RuleResultMetadata.CountCategory.Illegal, PasswordUtils.countMatchingCharacters(String.valueOf(this.illegalCharacters), password.getPassword()));
    }

    public String toString() {
        return String.format("%s@%h::reportAllFailures=%s,matchBehavior=%s,illegalCharacters=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.reportAllFailures, this.matchBehavior, Arrays.toString(this.illegalCharacters)});
    }
}

