/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.internals.metrics.RebalanceMetricsManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public final class ShareRebalanceMetricsManager
extends RebalanceMetricsManager {
    private final Sensor rebalanceSensor;
    public final MetricName rebalanceTotal;
    public final MetricName rebalanceRatePerHour;
    private long lastRebalanceEndMs = -1L;
    private long lastRebalanceStartMs = -1L;

    public ShareRebalanceMetricsManager(Metrics metrics) {
        super("consumer-share-coordinator-metrics");
        this.rebalanceTotal = this.createMetric(metrics, "rebalance-total", "The total number of rebalance events");
        this.rebalanceRatePerHour = this.createMetric(metrics, "rebalance-rate-per-hour", "The number of rebalance events per hour");
        this.rebalanceSensor = metrics.sensor("rebalance-latency");
        this.rebalanceSensor.add(this.rebalanceTotal, new CumulativeCount());
        this.rebalanceSensor.add(this.rebalanceRatePerHour, new Rate(TimeUnit.HOURS, new WindowedCount()));
    }

    @Override
    public void recordRebalanceStarted(long nowMs) {
        this.lastRebalanceStartMs = nowMs;
    }

    @Override
    public void recordRebalanceEnded(long nowMs) {
        this.lastRebalanceEndMs = nowMs;
        this.rebalanceSensor.record(nowMs - this.lastRebalanceStartMs);
    }

    @Override
    public boolean rebalanceStarted() {
        return this.lastRebalanceStartMs > this.lastRebalanceEndMs;
    }
}

