/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.IndexSettingsStoreFs;
import org.opensearch.client.opensearch.indices.IndexSettingsStoreHybrid;
import org.opensearch.client.opensearch.indices.StorageType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSettingsStore
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSettingsStore> {
    @Nullable
    private final Boolean allowMmap;
    @Nullable
    private final IndexSettingsStoreFs fs;
    @Nullable
    private final IndexSettingsStoreHybrid hybrid;
    @Nonnull
    private final List<String> preload;
    @Nullable
    private final Time statsRefreshInterval;
    @Nonnull
    private final StorageType type;
    public static final JsonpDeserializer<IndexSettingsStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsStore::setupIndexSettingsStoreDeserializer);

    private IndexSettingsStore(Builder builder) {
        this.allowMmap = builder.allowMmap;
        this.fs = builder.fs;
        this.hybrid = builder.hybrid;
        this.preload = ApiTypeHelper.unmodifiable(builder.preload);
        this.statsRefreshInterval = builder.statsRefreshInterval;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static IndexSettingsStore of(Function<Builder, ObjectBuilder<IndexSettingsStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowMmap() {
        return this.allowMmap;
    }

    @Nullable
    public final IndexSettingsStoreFs fs() {
        return this.fs;
    }

    @Nullable
    public final IndexSettingsStoreHybrid hybrid() {
        return this.hybrid;
    }

    @Nonnull
    public final List<String> preload() {
        return this.preload;
    }

    @Nullable
    public final Time statsRefreshInterval() {
        return this.statsRefreshInterval;
    }

    @Nonnull
    public final StorageType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowMmap != null) {
            generator.writeKey("allow_mmap");
            generator.write(this.allowMmap.booleanValue());
        }
        if (this.fs != null) {
            generator.writeKey("fs");
            this.fs.serialize(generator, mapper);
        }
        if (this.hybrid != null) {
            generator.writeKey("hybrid");
            this.hybrid.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.preload)) {
            generator.writeKey("preload");
            generator.writeStartArray();
            for (String item0 : this.preload) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.statsRefreshInterval != null) {
            generator.writeKey("stats_refresh_interval");
            this.statsRefreshInterval.serialize(generator, mapper);
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSettingsStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowMmap, JsonpDeserializer.booleanDeserializer(), "allow_mmap");
        op.add(Builder::fs, IndexSettingsStoreFs._DESERIALIZER, "fs");
        op.add(Builder::hybrid, IndexSettingsStoreHybrid._DESERIALIZER, "hybrid");
        op.add(Builder::preload, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "preload");
        op.add(Builder::statsRefreshInterval, Time._DESERIALIZER, "stats_refresh_interval");
        op.add(Builder::type, StorageType._DESERIALIZER, "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowMmap);
        result = 31 * result + Objects.hashCode(this.fs);
        result = 31 * result + Objects.hashCode(this.hybrid);
        result = 31 * result + Objects.hashCode(this.preload);
        result = 31 * result + Objects.hashCode(this.statsRefreshInterval);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSettingsStore other = (IndexSettingsStore)o;
        return Objects.equals(this.allowMmap, other.allowMmap) && Objects.equals(this.fs, other.fs) && Objects.equals(this.hybrid, other.hybrid) && Objects.equals(this.preload, other.preload) && Objects.equals(this.statsRefreshInterval, other.statsRefreshInterval) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSettingsStore> {
        @Nullable
        private Boolean allowMmap;
        @Nullable
        private IndexSettingsStoreFs fs;
        @Nullable
        private IndexSettingsStoreHybrid hybrid;
        @Nullable
        private List<String> preload;
        @Nullable
        private Time statsRefreshInterval;
        private StorageType type;

        public Builder() {
        }

        private Builder(IndexSettingsStore o) {
            this.allowMmap = o.allowMmap;
            this.fs = o.fs;
            this.hybrid = o.hybrid;
            this.preload = Builder._listCopy(o.preload);
            this.statsRefreshInterval = o.statsRefreshInterval;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.allowMmap = o.allowMmap;
            this.fs = o.fs;
            this.hybrid = o.hybrid;
            this.preload = Builder._listCopy(o.preload);
            this.statsRefreshInterval = o.statsRefreshInterval;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allowMmap(@Nullable Boolean value) {
            this.allowMmap = value;
            return this;
        }

        @Nonnull
        public final Builder fs(@Nullable IndexSettingsStoreFs value) {
            this.fs = value;
            return this;
        }

        @Nonnull
        public final Builder fs(Function<IndexSettingsStoreFs.Builder, ObjectBuilder<IndexSettingsStoreFs>> fn) {
            return this.fs(fn.apply(new IndexSettingsStoreFs.Builder()).build());
        }

        @Nonnull
        public final Builder hybrid(@Nullable IndexSettingsStoreHybrid value) {
            this.hybrid = value;
            return this;
        }

        @Nonnull
        public final Builder hybrid(Function<IndexSettingsStoreHybrid.Builder, ObjectBuilder<IndexSettingsStoreHybrid>> fn) {
            return this.hybrid(fn.apply(new IndexSettingsStoreHybrid.Builder()).build());
        }

        @Nonnull
        public final Builder preload(List<String> list) {
            this.preload = Builder._listAddAll(this.preload, list);
            return this;
        }

        @Nonnull
        public final Builder preload(String value, String ... values) {
            this.preload = Builder._listAdd(this.preload, value, values);
            return this;
        }

        @Nonnull
        public final Builder statsRefreshInterval(@Nullable Time value) {
            this.statsRefreshInterval = value;
            return this;
        }

        @Nonnull
        public final Builder statsRefreshInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.statsRefreshInterval(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder type(StorageType value) {
            this.type = value;
            return this;
        }

        @Nonnull
        public final Builder type(Function<StorageType.Builder, ObjectBuilder<StorageType>> fn) {
            return this.type(fn.apply(new StorageType.Builder()).build());
        }

        @Override
        @Nonnull
        public IndexSettingsStore build() {
            this._checkSingleUse();
            return new IndexSettingsStore(this);
        }
    }
}

