/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import org.opensearch.ml.common.agent.BedrockConverseModelProvider;
import org.opensearch.ml.common.agent.GeminiV1BetaGenerateContentModelProvider;
import org.opensearch.ml.common.agent.OpenaiV1ChatCompletionsModelProvider;
import org.opensearch.ml.common.input.execute.agent.ModelProviderType;
import org.opensearch.ml.common.model.ModelProvider;

public class ModelProviderFactory {
    public static ModelProvider getProvider(String providerType) {
        ModelProviderType type = ModelProviderType.from(providerType);
        return switch (type) {
            case ModelProviderType.BEDROCK_CONVERSE -> new BedrockConverseModelProvider();
            case ModelProviderType.GEMINI_V1BETA_GENERATE_CONTENT -> new GeminiV1BetaGenerateContentModelProvider();
            case ModelProviderType.OPENAI_V1_CHAT_COMPLETIONS -> new OpenaiV1ChatCompletionsModelProvider();
            default -> throw new IllegalArgumentException("Unsupported model provider type");
        };
    }
}

