/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CopyTagsFromSource;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceSpecification;
import software.amazon.awssdk.services.ec2.model.SnapshotLocationEnum;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateSnapshotsRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::description)).setter(CreateSnapshotsRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<InstanceSpecification> INSTANCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceSpecification").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::instanceSpecification)).setter(CreateSnapshotsRequest.setter(Builder::instanceSpecification)).constructor(InstanceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSpecification").unmarshallLocationName("InstanceSpecification").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::outpostArn)).setter(CreateSnapshotsRequest.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("OutpostArn").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::tagSpecifications)).setter(CreateSnapshotsRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::dryRun)).setter(CreateSnapshotsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> COPY_TAGS_FROM_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyTagsFromSource").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::copyTagsFromSourceAsString)).setter(CreateSnapshotsRequest.setter(Builder::copyTagsFromSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsFromSource").unmarshallLocationName("CopyTagsFromSource").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateSnapshotsRequest.getter(CreateSnapshotsRequest::locationAsString)).setter(CreateSnapshotsRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, INSTANCE_SPECIFICATION_FIELD, OUTPOST_ARN_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, COPY_TAGS_FROM_SOURCE_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSnapshotsRequest.memberNameToFieldInitializer();
    private final String description;
    private final InstanceSpecification instanceSpecification;
    private final String outpostArn;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;
    private final String copyTagsFromSource;
    private final String location;

    private CreateSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.instanceSpecification = builder.instanceSpecification;
        this.outpostArn = builder.outpostArn;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.copyTagsFromSource = builder.copyTagsFromSource;
        this.location = builder.location;
    }

    public final String description() {
        return this.description;
    }

    public final InstanceSpecification instanceSpecification() {
        return this.instanceSpecification;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final CopyTagsFromSource copyTagsFromSource() {
        return CopyTagsFromSource.fromValue(this.copyTagsFromSource);
    }

    public final String copyTagsFromSourceAsString() {
        return this.copyTagsFromSource;
    }

    public final SnapshotLocationEnum location() {
        return SnapshotLocationEnum.fromValue(this.location);
    }

    public final String locationAsString() {
        return this.location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsFromSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotsRequest)) {
            return false;
        }
        CreateSnapshotsRequest other = (CreateSnapshotsRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceSpecification(), other.instanceSpecification()) && Objects.equals(this.outpostArn(), other.outpostArn()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.copyTagsFromSourceAsString(), other.copyTagsFromSourceAsString()) && Objects.equals(this.locationAsString(), other.locationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotsRequest").add("Description", (Object)this.description()).add("InstanceSpecification", (Object)this.instanceSpecification()).add("OutpostArn", (Object)this.outpostArn()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).add("CopyTagsFromSource", (Object)this.copyTagsFromSourceAsString()).add("Location", (Object)this.locationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InstanceSpecification": {
                return Optional.ofNullable(clazz.cast(this.instanceSpecification()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "CopyTagsFromSource": {
                return Optional.ofNullable(clazz.cast(this.copyTagsFromSourceAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.locationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InstanceSpecification", INSTANCE_SPECIFICATION_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("CopyTagsFromSource", COPY_TAGS_FROM_SOURCE_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotsRequest, T> g) {
        return obj -> g.apply((CreateSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private InstanceSpecification instanceSpecification;
        private String outpostArn;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private String copyTagsFromSource;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotsRequest model) {
            super(model);
            this.description(model.description);
            this.instanceSpecification(model.instanceSpecification);
            this.outpostArn(model.outpostArn);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
            this.copyTagsFromSource(model.copyTagsFromSource);
            this.location(model.location);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InstanceSpecification.Builder getInstanceSpecification() {
            return this.instanceSpecification != null ? this.instanceSpecification.toBuilder() : null;
        }

        public final void setInstanceSpecification(InstanceSpecification.BuilderImpl instanceSpecification) {
            this.instanceSpecification = instanceSpecification != null ? instanceSpecification.build() : null;
        }

        @Override
        public final Builder instanceSpecification(InstanceSpecification instanceSpecification) {
            this.instanceSpecification = instanceSpecification;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getCopyTagsFromSource() {
            return this.copyTagsFromSource;
        }

        public final void setCopyTagsFromSource(String copyTagsFromSource) {
            this.copyTagsFromSource = copyTagsFromSource;
        }

        @Override
        public final Builder copyTagsFromSource(String copyTagsFromSource) {
            this.copyTagsFromSource = copyTagsFromSource;
            return this;
        }

        @Override
        public final Builder copyTagsFromSource(CopyTagsFromSource copyTagsFromSource) {
            this.copyTagsFromSource(copyTagsFromSource == null ? null : copyTagsFromSource.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public final Builder location(SnapshotLocationEnum location) {
            this.location(location == null ? null : location.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotsRequest build() {
            return new CreateSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotsRequest> {
        public Builder description(String var1);

        public Builder instanceSpecification(InstanceSpecification var1);

        default public Builder instanceSpecification(Consumer<InstanceSpecification.Builder> instanceSpecification) {
            return this.instanceSpecification((InstanceSpecification)((InstanceSpecification.Builder)InstanceSpecification.builder().applyMutation(instanceSpecification)).build());
        }

        public Builder outpostArn(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder copyTagsFromSource(String var1);

        public Builder copyTagsFromSource(CopyTagsFromSource var1);

        public Builder location(String var1);

        public Builder location(SnapshotLocationEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

