/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;

public abstract class OneSidedStDevAccumulator<R>
implements ConvergingAccumulator<R> {
    private static final double ALPHA = 0.5;
    private final int minValuesAccepted;
    private final int convergenceThreshold;
    private final boolean highIsCritical;
    private final int sign;
    protected R accumulatedValue;
    private int valuesAccepted;
    private int witnesses;
    private double sumConvergeVal;
    private double sumSqConvergeVal;

    public OneSidedStDevAccumulator(boolean highIsCritical, double precision, int minValuesAccepted, int maxValuesAccepted) {
        this.highIsCritical = highIsCritical;
        this.convergenceThreshold = precision < 1.0 / (double)maxValuesAccepted ? maxValuesAccepted : (int)(1.0 / precision);
        this.minValuesAccepted = Math.min(minValuesAccepted, maxValuesAccepted);
        this.valuesAccepted = 0;
        this.witnesses = 0;
        this.sumConvergeVal = 0.0;
        this.sumSqConvergeVal = 0.0;
        this.sign = highIsCritical ? 1 : -1;
        this.accumulatedValue = null;
    }

    @Override
    public void accept(R result) {
        this.accumulateValue(result);
        double value = this.getConvergingValue(result);
        this.sumConvergeVal += value;
        this.sumSqConvergeVal += value * value;
        ++this.valuesAccepted;
        if (this.valuesAccepted >= this.minValuesAccepted && (double)this.sign * (value - this.getMean()) + 1.0E-6 > 0.5 * this.getDeviation()) {
            ++this.witnesses;
        }
    }

    @Override
    public int getValuesAccepted() {
        return this.valuesAccepted;
    }

    @Override
    public boolean isConverged() {
        return this.witnesses >= this.convergenceThreshold;
    }

    @Override
    public R getAccumulatedValue() {
        return this.accumulatedValue;
    }

    protected abstract double getConvergingValue(R var1);

    protected abstract void accumulateValue(R var1);

    public int getWitnesses() {
        return this.witnesses;
    }

    public double getMean() {
        return this.valuesAccepted == 0 ? 0.0 : this.sumConvergeVal / (double)this.valuesAccepted;
    }

    public double getDeviation() {
        if (this.valuesAccepted <= 1) {
            return 0.0;
        }
        double mean = this.sumConvergeVal / (double)this.valuesAccepted;
        double stdev = Math.max(0.0, this.sumSqConvergeVal / (double)this.valuesAccepted - mean * mean);
        stdev = Math.sqrt((double)this.valuesAccepted * stdev / (double)(this.valuesAccepted - 1));
        return stdev;
    }
}

