/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.datasources.exceptions.DataSourceClientException;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.QueryEngineException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.opensearch.response.error.ErrorMessageFactory;
import org.opensearch.sql.plugin.request.PPLQueryRequestFactory;
import org.opensearch.sql.plugin.transport.PPLQueryAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestPPLQueryAction
extends BaseRestHandler {
    public static final String QUERY_API_ENDPOINT = "/_plugins/_ppl";
    public static final String EXPLAIN_API_ENDPOINT = "/_plugins/_ppl/_explain";
    private static final Logger LOG = LogManager.getLogger();

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof IllegalArgumentException || e instanceof IndexNotFoundException || e instanceof SemanticCheckException || e instanceof ExpressionEvaluationException || e instanceof QueryEngineException || e instanceof SyntaxCheckException || e instanceof DataSourceClientException || e instanceof IllegalAccessException;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, QUERY_API_ENDPOINT), (Object)new RestHandler.Route(RestRequest.Method.POST, EXPLAIN_API_ENDPOINT));
    }

    public String getName() {
        return "ppl_query_action";
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "mode", "sanitize"));
        return responseParams;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) {
        final TransportPPLQueryRequest transportPPLQueryRequest = new TransportPPLQueryRequest(PPLQueryRequestFactory.getPPLRequest(request));
        return channel -> nodeClient.execute((ActionType)PPLQueryAction.INSTANCE, (ActionRequest)transportPPLQueryRequest, (ActionListener)new ActionListener<TransportPPLQueryResponse>(this){
            final /* synthetic */ RestPPLQueryAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(TransportPPLQueryResponse response) {
                this.this$0.sendResponse(channel, RestStatus.OK, response.getContentType(), response.getResult());
            }

            public void onFailure(Exception e) {
                if (transportPPLQueryRequest.isExplainRequest()) {
                    LOG.error("Error happened during explain", (Throwable)e);
                    if (RestPPLQueryAction.isClientError(e)) {
                        this.this$0.reportError(channel, e, RestStatus.BAD_REQUEST);
                    } else {
                        this.this$0.reportError(channel, e, RestStatus.INTERNAL_SERVER_ERROR);
                    }
                } else if (e instanceof OpenSearchException) {
                    Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_CUS).increment();
                    OpenSearchException exception = (OpenSearchException)e;
                    this.this$0.reportError(channel, (Exception)exception, exception.status());
                } else {
                    LOG.error("Error happened during query handling", (Throwable)e);
                    if (RestPPLQueryAction.isClientError(e)) {
                        Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_CUS).increment();
                        this.this$0.reportError(channel, e, RestStatus.BAD_REQUEST);
                    } else {
                        Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_SYS).increment();
                        this.this$0.reportError(channel, e, RestStatus.INTERNAL_SERVER_ERROR);
                    }
                }
            }
        });
    }

    private void sendResponse(RestChannel channel, RestStatus status, String contentType, String content) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, contentType, content));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, ErrorMessageFactory.createErrorMessage((Throwable)e, (int)status.getStatus()).toString()));
    }
}

