/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.SimplePatternTokenizer;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenizerFactory;

public class SimplePatternTokenizerFactory
extends AbstractTokenizerFactory {
    private final Automaton dfa;

    public SimplePatternTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        String pattern = settings.get("pattern", "");
        this.dfa = Operations.determinize((Automaton)new RegExp(pattern).toAutomaton(), (int)10000);
    }

    public Tokenizer create() {
        return new SimplePatternTokenizer(this.dfa);
    }
}

