/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.FixedByteArrayOutputStream;
import oracle.security.pki.util.StreamableInputException;
import oracle.security.pki.util.Utils;

public class ASN1GenericPrimitive
implements ASN1TaggedObject {
    private ASN1Header a;
    private byte[] b;

    public ASN1GenericPrimitive(byte[] byArray, int n) {
        this(byArray, n, 128);
    }

    public ASN1GenericPrimitive(byte[] byArray, int n, int n2) {
        this.a(byArray, n, n2);
    }

    public ASN1GenericPrimitive(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public ASN1GenericPrimitive(ASN1Object aSN1Object, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Utils.toBytes(aSN1Object));
        try {
            ASN1Header aSN1Header = new ASN1Header(byteArrayInputStream);
            this.a(aSN1Header.d(byteArrayInputStream), n, n2);
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public ASN1GenericPrimitive(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericPrimitive(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, 128);
    }

    public ASN1GenericPrimitive(InputStream inputStream, int n, int n2) throws IOException {
        this.input(inputStream);
        this.a.e(n);
        this.a.d(n2);
    }

    private void a(byte[] byArray, int n, int n2) {
        this.b = byArray;
        this.a = new ASN1Header(n, n2, 0, byArray.length);
    }

    @Override
    public ASN1Header a() {
        return this.a;
    }

    public int b() {
        return this.a.a();
    }

    public int c() {
        return this.a.b();
    }

    public byte[] d() {
        return this.b;
    }

    public ASN1Object a(int n) throws IOException {
        return this.a(n, 0);
    }

    public ASN1Object a(int n, int n2) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(n, n2, 0, this.b.length);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(aSN1Header.length() + this.b.length);
        aSN1Header.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(this.b);
        return ASN1Utils.a(new ByteArrayInputStream(fixedByteArrayOutputStream.getBytes()));
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.f(0);
        this.a(aSN1Header.d(inputStream), aSN1Header.a(), aSN1Header.b());
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        outputStream.write(this.b);
    }

    @Override
    public int length() {
        return this.a.g();
    }
}

