/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.reference.DereferencerContext;
import io.swagger.v3.parser.reference.OpenAPI31Traverser;
import io.swagger.v3.parser.reference.OpenAPIDereferencer;
import io.swagger.v3.parser.reference.Reference;
import io.swagger.v3.parser.reference.ReferenceVisitor;
import io.swagger.v3.parser.reference.Traverser;
import io.swagger.v3.parser.reference.Visitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIDereferencer31
implements OpenAPIDereferencer {
    protected final Set<String> messages = new HashSet<String>();
    private OpenAPI openAPI;
    private SwaggerParseResult result;

    @Override
    public boolean canDereference(DereferencerContext context) {
        return context.openApi != null && context.openApi.getOpenapi().startsWith("3.1");
    }

    @Override
    public void dereference(DereferencerContext context, Iterator<OpenAPIDereferencer> chain) {
        if (!this.canDereference(context) && chain.hasNext() && chain.next().canDereference(context)) {
            chain.next().dereference(context, chain);
            return;
        }
        this.openAPI = context.openApi;
        this.result = context.swaggerParseResult;
        if (this.openAPI == null) {
            return;
        }
        LinkedHashMap<String, Reference> refSet = new LinkedHashMap<String, Reference>();
        LinkedHashSet<String> msgs = new LinkedHashSet<String>();
        if (StringUtils.isBlank(context.getRootUri())) {
            context.rootUri("local");
            context.currentUri("local");
        }
        if (context.getRootUri().equals("local")) {
            Reference localReference = new Reference().referenceSet(refSet).uri(context.getCurrentUri()).messages(msgs).jsonNode(Json31.mapper().convertValue((Object)this.openAPI, JsonNode.class)).auths(context.getAuths());
            refSet.put("local", localReference);
        }
        Reference reference = new Reference().referenceSet(refSet).uri(context.getCurrentUri()).messages(msgs).auths(context.getAuths());
        Traverser traverser = this.buildTraverser(context);
        ReferenceVisitor referenceVisitor = this.buildReferenceVisitorWithContext(context, reference, traverser);
        try {
            this.openAPI = traverser.traverse(context.getOpenApi(), referenceVisitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (this.openAPI == null) {
            return;
        }
        this.result.setOpenAPI(this.openAPI);
        this.result.getMessages().addAll(reference.getMessages());
    }

    @Override
    public Traverser buildTraverser(DereferencerContext context) {
        return new OpenAPI31Traverser(context);
    }

    @Override
    public Visitor buildReferenceVisitor(DereferencerContext context, Reference reference, Traverser traverser) {
        return new ReferenceVisitor(reference, (OpenAPI31Traverser)traverser, new HashSet<Object>(), new HashMap<Object, Object>());
    }

    public ReferenceVisitor buildReferenceVisitorWithContext(DereferencerContext context, Reference reference, Traverser traverser) {
        return new ReferenceVisitor(reference, (OpenAPI31Traverser)traverser, new HashSet<Object>(), new HashMap<Object, Object>(), context);
    }
}

