// Define the macros for the pieces of the CUDA toolkit version.  The BUILD
// macro is not accurate, but the build number is not readily available to the
// compiler front end.
#ifdef CUDA_VERSION
  #define __CUDACC_VER_MAJOR__ (CUDA_VERSION / 1000)
  #define __CUDACC_VER_MINOR__ ((CUDA_VERSION % 1000) / 10)
  #define __CUDACC_VER_BUILD__ (CUDA_VERSION % 10)
#endif

// If RDC is turned on, define the CUDA-specific macro for that.
#ifdef _NVHPC_RDC
  #define __CUDACC_RDC__ 1
#endif

// -stdpar=gpu turns on CUDA support without defining __CUDACC__.
// But __CUDACC__ needs to be defined when <cuda_runtime.h> is included.
#if defined(_NVHPC_STDPAR_GPU) && !defined(__CUDACC__)
  #define __CUDACC__ 1
  #include <cuda_runtime.h>
  #undef __CUDACC__
#else
  #include <cuda_runtime.h>
#endif
