/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.ctp;

import ca.odell.glazedlists.impl.ctp.CTPConnectionManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Logger;

class StartServer
implements Runnable {
    private static Logger logger = Logger.getLogger(StartServer.class.toString());
    private CTPConnectionManager connectionManager = null;
    private int listenPort = -1;

    public StartServer(CTPConnectionManager connectionManager, int listenPort) {
        this.connectionManager = connectionManager;
        this.listenPort = listenPort;
    }

    @Override
    public void run() {
        try {
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = serverChannel.socket();
            serverSocket.setReuseAddress(false);
            InetSocketAddress listenAddress = new InetSocketAddress(this.listenPort);
            serverSocket.bind(listenAddress);
            serverChannel.configureBlocking(false);
            serverChannel.register(this.connectionManager.getNIODaemon().getSelector(), 16);
            this.connectionManager.getNIODaemon().setServer(this.connectionManager);
            logger.info("Connection Manager ready, listening on " + listenAddress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

