/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.EmbeddedSetCache;

public class EmbeddedMultimapCacheManager<K, V>
implements MultimapCacheManager<K, V> {
    private final EmbeddedCacheManager cacheManager;

    public EmbeddedMultimapCacheManager(EmbeddedCacheManager embeddedMultimapCacheManager) {
        this.cacheManager = embeddedMultimapCacheManager;
    }

    @Override
    public Configuration defineConfiguration(String name, Configuration configuration) {
        return this.cacheManager.defineConfiguration(name, configuration);
    }

    @Override
    public MultimapCache<K, V> get(String name, boolean supportsDuplicates) {
        Cache cache = this.cacheManager.getCache(name, true);
        EmbeddedMultimapCache multimapCache = new EmbeddedMultimapCache(cache, supportsDuplicates);
        return multimapCache;
    }

    public EmbeddedMultimapListCache<K, V> getMultimapList(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalStateException("Cache must exist: " + cacheName);
        }
        return new EmbeddedMultimapListCache(cache);
    }

    public EmbeddedMultimapSortedSetCache<K, V> getMultimapSortedSet(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalStateException("Cache must exist: " + cacheName);
        }
        return new EmbeddedMultimapSortedSetCache(cache);
    }

    public <HK, HV> EmbeddedMultimapPairCache<K, HK, HV> getMultimapPair(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalStateException("Cache must exist: " + cacheName);
        }
        return new EmbeddedMultimapPairCache(cache);
    }

    public EmbeddedSetCache<K, V> getMultimapSet(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalStateException("Cache must exist: " + cacheName);
        }
        return new EmbeddedSetCache(cache);
    }
}

