/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.CustomChangeException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate26_5_0_OrgTablesSetDefaultCharsetAndCollation
extends CustomKeycloakTask {
    @Override
    protected boolean isApplicable() throws CustomChangeException {
        if (!(this.database instanceof MySQLDatabase)) {
            return false;
        }
        return this.tableExists("ORG");
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String schemaName = this.database.escapeObjectName(this.database.getDefaultSchemaName(), Schema.class);
        try (Statement st = this.connection.createStatement();
             ResultSet rs = st.executeQuery("SELECT DEFAULT_CHARACTER_SET_NAME as charset, DEFAULT_COLLATION_NAME as collation FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '" + schemaName + "'");){
            if (rs.next()) {
                String charset = rs.getString("charset");
                String collation = rs.getString("collation");
                String orgTable = this.getTableName("ORG");
                String orgInvTable = this.getTableName("ORG_INVITATION");
                this.statements.add(new RawSqlStatement("SET FOREIGN_KEY_CHECKS=0"));
                if (this.tableExists("ORG_INVITATION")) {
                    this.statements.add(new RawSqlStatement("ALTER TABLE " + orgInvTable + " DROP FOREIGN KEY FK_ORG_INVITATION_ORG"));
                    this.statements.add(new RawSqlStatement("ALTER TABLE " + orgInvTable + " CONVERT TO CHARACTER SET " + charset + " COLLATE " + collation));
                }
                this.statements.add(new RawSqlStatement("ALTER TABLE " + orgTable + " MODIFY ID VARCHAR(255) CHARACTER SET " + charset + " COLLATE " + collation + " NOT NULL"));
                if (this.tableExists("ORG_INVITATION")) {
                    this.statements.add(new RawSqlStatement("ALTER TABLE " + orgInvTable + " ADD CONSTRAINT FK_ORG_INVITATION_ORG FOREIGN KEY (ORGANIZATION_ID) REFERENCES " + orgTable + " (ID)"));
                }
                this.statements.add(new RawSqlStatement("SET FOREIGN_KEY_CHECKS=1"));
            }
        }
        catch (SQLException e) {
            throw new CustomChangeException("Failed to read database default character set", (Throwable)e);
        }
        this.confirmationMessage.append("Updated charset to default charset and collation for both ORG.ID column and ORG_INVITATION table (if exists)");
    }

    @Override
    protected String getTaskId() {
        return "Update ORG and ORG_INVITATION tables charset and collation";
    }

    private boolean tableExists(String tableName) throws CustomChangeException {
        try {
            String correctedTableName = this.database.correctObjectName(tableName, Table.class);
            return SnapshotGeneratorFactory.getInstance().has((DatabaseObject)new Table().setName(correctedTableName), this.database);
        }
        catch (Exception e) {
            throw new CustomChangeException("Failed to check for existence of ORG table", (Throwable)e);
        }
    }
}

