/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.NaturalIdLogging;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.Resolution;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class NaturalIdResolutionsImpl
implements NaturalIdResolutions,
Serializable {
    private static final Logger LOG = Logger.getLogger(NaturalIdResolutionsImpl.class);
    private final StatefulPersistenceContext persistenceContext;
    private final ConcurrentHashMap<EntityMappingType, EntityResolutions> resolutionsByEntity = new ConcurrentHashMap();

    public NaturalIdResolutionsImpl(StatefulPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    protected SharedSessionContractImplementor session() {
        return this.persistenceContext.getSession();
    }

    @Override
    public boolean cacheResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        this.validateNaturalId(entityDescriptor, naturalId);
        return this.cacheResolutionLocally(id, naturalId, entityDescriptor);
    }

    @Override
    public void cacheResolutionFromLoad(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        boolean justAddedLocally;
        Object object;
        String string = entityDescriptor.getEntityName();
        if (naturalId instanceof Object[]) {
            Object[] array = (Object[])naturalId;
            object = Arrays.toString(array);
        } else {
            object = naturalId;
        }
        NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.cachingNaturalIdResolutionFromLoad(string, object, id);
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping != null && (justAddedLocally = this.cacheResolution(id, naturalId, entityDescriptor)) && naturalIdMapping.getCacheAccess() != null) {
            EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
            this.manageSharedResolution(persister, id, naturalId, (Object)null, CachedNaturalIdValueSource.LOAD);
        }
    }

    private boolean cacheResolutionLocally(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        EntityResolutions resolutions;
        Object object;
        assert (entityDescriptor.getNaturalIdMapping() != null);
        assert (this.isValidValue(naturalId, entityDescriptor));
        String string = entityDescriptor.getEntityName();
        if (naturalId instanceof Object[]) {
            Object[] array = (Object[])naturalId;
            object = Arrays.toString(array);
        } else {
            object = naturalId;
        }
        NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.locallyCachingNaturalIdResolution(string, object, id);
        EntityMappingType rootEntityDescriptor = entityDescriptor.getRootEntityDescriptor();
        EntityResolutions previousEntry = this.resolutionsByEntity.get(rootEntityDescriptor);
        if (previousEntry != null) {
            resolutions = previousEntry;
        } else {
            resolutions = new EntityResolutions(rootEntityDescriptor, this.persistenceContext);
            this.resolutionsByEntity.put(rootEntityDescriptor, resolutions);
        }
        return resolutions.cache(id, naturalId);
    }

    @Override
    public Object removeResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        Resolution cachedNaturalId;
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        this.validateNaturalId(persister, naturalId);
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        Object sessionCachedNaturalIdValues = null;
        if (entityNaturalIdResolutionCache != null && (cachedNaturalId = entityNaturalIdResolutionCache.pkToNaturalIdMap.remove(id)) != null) {
            entityNaturalIdResolutionCache.naturalIdToPkMap.remove(cachedNaturalId);
            sessionCachedNaturalIdValues = cachedNaturalId.getNaturalIdValue();
        }
        return sessionCachedNaturalIdValues;
    }

    @Override
    public void manageLocalResolution(Object id, Object naturalIdValue, EntityMappingType entityDescriptor, CachedNaturalIdValueSource source) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        this.cacheResolutionLocally(id, naturalIdValue, entityDescriptor);
    }

    @Override
    public Object removeLocalResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping != null) {
            Object object;
            String string = entityDescriptor.getEntityName();
            if (naturalId instanceof Object[]) {
                Object[] array = (Object[])naturalId;
                object = Arrays.toString(array);
            } else {
                object = naturalId;
            }
            NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.removingLocallyCachedNaturalIdResolution(string, object, id);
            EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
            Object localNaturalIdValues = this.removeNaturalIdCrossReference(id, naturalId, persister);
            return localNaturalIdValues == null ? naturalId : localNaturalIdValues;
        }
        return null;
    }

    private Object removeNaturalIdCrossReference(Object id, Object naturalId, EntityPersister persister) {
        this.validateNaturalId(persister, naturalId);
        Object sessionCachedNaturalId = this.removeSessionCachedNaturalIdValue(id, persister);
        if (persister.hasNaturalIdCache()) {
            SharedSessionContractImplementor session = this.session();
            NaturalIdResolutionsImpl.evictCachedNaturalId(naturalId, persister, session);
            if (sessionCachedNaturalId != null && !Objects.deepEquals(sessionCachedNaturalId, naturalId)) {
                NaturalIdResolutionsImpl.evictCachedNaturalId(sessionCachedNaturalId, persister, session);
            }
        }
        return sessionCachedNaturalId;
    }

    private static void evictCachedNaturalId(Object naturalId, EntityPersister persister, SharedSessionContractImplementor session) {
        NaturalIdDataAccess cacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
        cacheAccessStrategy.evict(cacheAccessStrategy.generateCacheKey(naturalId, persister, session));
    }

    private Object removeSessionCachedNaturalIdValue(Object id, EntityPersister persister) {
        Resolution cachedNaturalId;
        EntityResolutions entityResolutions = this.resolutionsByEntity.get(persister);
        if (entityResolutions != null && (cachedNaturalId = entityResolutions.pkToNaturalIdMap.remove(id)) != null) {
            entityResolutions.naturalIdToPkMap.remove(cachedNaturalId);
            return cachedNaturalId.getNaturalIdValue();
        }
        return null;
    }

    @Override
    public void manageSharedResolution(Object id, Object naturalId, Object previousNaturalId, EntityMappingType entityDescriptor, CachedNaturalIdValueSource source) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping != null && naturalIdMapping.getCacheAccess() != null) {
            this.manageSharedResolution(entityDescriptor.getEntityPersister(), id, naturalId, previousNaturalId, source);
        }
    }

    private void manageSharedResolution(EntityPersister persister, Object id, Object naturalIdValues, Object previousNaturalIdValues, CachedNaturalIdValueSource source) {
        NaturalIdDataAccess cacheAccess = persister.getNaturalIdMapping().getCacheAccess();
        if (cacheAccess != null) {
            EntityMappingType rootEntityDescriptor = persister.getRootEntityDescriptor();
            EntityPersister rootEntityPersister = rootEntityDescriptor.getEntityPersister();
            Object cacheKey = cacheAccess.generateCacheKey(naturalIdValues, rootEntityPersister, this.session());
            switch (source) {
                case LOAD: {
                    this.cacheFromLoad(persister, id, cacheKey, cacheAccess, rootEntityDescriptor, rootEntityPersister);
                    break;
                }
                case INSERT: {
                    this.cacheFromInsert(id, cacheAccess, cacheKey, rootEntityDescriptor, rootEntityPersister);
                    break;
                }
                case UPDATE: {
                    this.cacheFromUpdate(id, previousNaturalIdValues, cacheAccess, rootEntityPersister, cacheKey, rootEntityDescriptor);
                    break;
                }
                default: {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Unexpected CachedNaturalIdValueSource [" + String.valueOf((Object)source) + "]"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFromUpdate(Object id, Object previousNaturalIdValues, NaturalIdDataAccess cacheAccess, EntityPersister rootEntityPersister, Object cacheKey, EntityMappingType rootEntityDescriptor) {
        SharedSessionContractImplementor session = this.session();
        Object previousCacheKey = cacheAccess.generateCacheKey(previousNaturalIdValues, rootEntityPersister, session);
        if (cacheKey.equals(previousCacheKey)) {
            return;
        }
        SoftLock removalLock = cacheAccess.lockItem(session, previousCacheKey, null);
        cacheAccess.remove(session, previousCacheKey);
        SoftLock lock = cacheAccess.lockItem(session, cacheKey, null);
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        EventMonitor eventMonitor = session.getEventMonitor();
        boolean put = false;
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        try {
            put = cacheAccess.update(session, cacheKey, id);
            if (put && statistics.isStatisticsEnabled()) {
                statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, this.session(), cacheAccess, rootEntityPersister, put, true, EventMonitor.CacheActionDescription.ENTITY_UPDATE);
        }
        session.asEventSource().getActionQueue().registerProcess((success, sess) -> {
            cacheAccess.unlockItem(sess, previousCacheKey, removalLock);
            if (success) {
                boolean putAfterUpdate = false;
                DiagnosticEvent cachePutEventAfterUpdate = eventMonitor.beginCachePutEvent();
                try {
                    putAfterUpdate = cacheAccess.afterUpdate(sess, cacheKey, id, lock);
                    if (!putAfterUpdate || !statistics.isStatisticsEnabled()) return;
                    statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    return;
                }
                finally {
                    eventMonitor.completeCachePutEvent(cachePutEventAfterUpdate, this.session(), cacheAccess, rootEntityPersister, putAfterUpdate, true, EventMonitor.CacheActionDescription.ENTITY_AFTER_UPDATE);
                }
            } else {
                cacheAccess.unlockItem(sess, cacheKey, lock);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFromInsert(Object id, NaturalIdDataAccess cacheAccess, Object cacheKey, EntityMappingType rootEntityDescriptor, EntityPersister rootEntityPersister) {
        SharedSessionContractImplementor session = this.session();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        EventMonitor eventMonitor = session.getEventMonitor();
        boolean put = false;
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        try {
            put = cacheAccess.insert(session, cacheKey, id);
            if (put && statistics.isStatisticsEnabled()) {
                statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, this.session(), cacheAccess, rootEntityPersister, put, true, EventMonitor.CacheActionDescription.ENTITY_INSERT);
        }
        session.asEventSource().getActionQueue().registerProcess((success, sess) -> {
            if (success) {
                boolean changed = cacheAccess.afterInsert(sess, cacheKey, id);
                if (changed && statistics.isStatisticsEnabled()) {
                    statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                }
            } else {
                cacheAccess.evict(cacheKey);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFromLoad(EntityPersister persister, Object id, Object cacheKey, NaturalIdDataAccess cacheAccess, EntityMappingType rootEntityDescriptor, EntityPersister rootEntityPersister) {
        SharedSessionContractImplementor session = this.session();
        if (CacheHelper.fromSharedCache(session, cacheKey, persister, (CachedDomainDataAccess)cacheAccess) != null) {
            return;
        }
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        EventMonitor eventMonitor = session.getEventMonitor();
        boolean put = false;
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        try {
            put = cacheAccess.putFromLoad(session, cacheKey, id, null);
            if (put && statistics.isStatisticsEnabled()) {
                statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, session, cacheAccess, rootEntityPersister, put, true, EventMonitor.CacheActionDescription.ENTITY_LOAD);
        }
    }

    @Override
    public void removeSharedResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        this.removeSharedResolution(id, naturalId, entityDescriptor, false);
    }

    @Override
    public void removeSharedResolution(Object id, Object naturalId, EntityMappingType entityDescriptor, boolean delayToAfterTransactionCompletion) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        NaturalIdDataAccess cacheAccess = naturalIdMapping.getCacheAccess();
        if (cacheAccess == null) {
            return;
        }
        SharedSessionContractImplementor session = this.session();
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        Object naturalIdCacheKey = cacheAccess.generateCacheKey(naturalId, persister, session);
        if (delayToAfterTransactionCompletion) {
            session.asEventSource().getActionQueue().registerProcess((success, sess) -> {
                if (success) {
                    cacheAccess.evict(naturalIdCacheKey);
                }
            });
        } else {
            cacheAccess.evict(naturalIdCacheKey);
        }
    }

    @Override
    public void handleSynchronization(Object pk, Object entity, EntityMappingType entityDescriptor) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping != null) {
            Object naturalIdValuesFromCurrentObjectState;
            boolean changed;
            EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
            boolean bl = changed = !this.sameAsCached(persister, pk, naturalIdValuesFromCurrentObjectState = naturalIdMapping.extractNaturalIdFromEntity(entity));
            if (changed) {
                Object cachedNaturalIdValues = this.findCachedNaturalIdById(pk, persister);
                this.cacheResolution(pk, naturalIdValuesFromCurrentObjectState, persister);
                this.stashInvalidNaturalIdReference(persister, cachedNaturalIdValues);
                this.removeSharedResolution(pk, cachedNaturalIdValues, persister, false);
            }
        }
    }

    @Override
    public void cleanupFromSynchronizations() {
        this.unStashInvalidNaturalIdReferences();
    }

    @Override
    public void handleEviction(Object id, Object object, EntityMappingType entityDescriptor) {
        this.removeResolution(id, this.findCachedNaturalIdById(id, entityDescriptor), entityDescriptor);
    }

    public boolean sameAsCached(EntityPersister persister, Object pk, Object naturalIdValues) {
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        return entityNaturalIdResolutionCache != null && entityNaturalIdResolutionCache.sameAsCached(pk, naturalIdValues);
    }

    protected EntityPersister locatePersisterForKey(EntityPersister persister) {
        return persister.getRootEntityDescriptor().getEntityPersister();
    }

    protected void validateNaturalId(EntityMappingType entityDescriptor, Object naturalIdValues) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            throw new IllegalArgumentException("Entity did not define a natural id");
        }
        naturalIdMapping.validateInternalForm(naturalIdValues);
    }

    private boolean isValidValue(Object naturalIdValues, EntityMappingType entityDescriptor) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            throw new IllegalArgumentException("Entity did not define a natural id");
        }
        naturalIdMapping.validateInternalForm(naturalIdValues);
        return true;
    }

    @Override
    public Object findCachedNaturalIdById(Object id, EntityMappingType entityDescriptor) {
        EntityPersister persister;
        EntityResolutions entityNaturalIdResolutionCache;
        if (LoadingLogger.TRACE_ENABLED) {
            LoadingLogger.LOGGER.tracef("Starting NaturalIdResolutionsImpl.#findCachedNaturalIdById( `%s`, `%s` )", (Object)entityDescriptor.getEntityName(), id);
        }
        if ((entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister()))) == null) {
            return null;
        }
        Resolution cachedNaturalId = entityNaturalIdResolutionCache.pkToNaturalIdMap.get(id);
        if (cachedNaturalId == null) {
            return null;
        }
        return cachedNaturalId.getNaturalIdValue();
    }

    @Override
    public Object findCachedIdByNaturalId(Object naturalId, EntityMappingType entityDescriptor) {
        if (LoadingLogger.TRACE_ENABLED) {
            LoadingLogger.LOGGER.tracef("Starting NaturalIdResolutionsImpl.#findCachedIdByNaturalId( `%s`, `%s` )", (Object)entityDescriptor.getEntityName(), naturalId);
        }
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        this.validateNaturalId(persister, naturalId);
        EntityResolutions resolutionCache = this.resolutionsByEntity.get(persister);
        ResolutionImpl cachedNaturalId = new ResolutionImpl(persister, naturalId, this.persistenceContext);
        if (resolutionCache != null) {
            Object identifier = resolutionCache.naturalIdToPkMap.get(cachedNaturalId);
            if (identifier != null) {
                if (NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.isTraceEnabled()) {
                    NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.resolvedNaturalIdInSessionCache(naturalId, identifier, entityDescriptor.getEntityName());
                }
                return identifier;
            }
            if (resolutionCache.containsInvalidNaturalIdReference(naturalId)) {
                return INVALID_NATURAL_ID_REFERENCE;
            }
        }
        if (!persister.hasNaturalIdCache()) {
            return null;
        }
        NaturalIdDataAccess cacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
        SharedSessionContractImplementor session = this.session();
        Object cacheKey = cacheAccessStrategy.generateCacheKey(naturalId, persister, session);
        Object id = CacheHelper.fromSharedCache(session, cacheKey, persister, true, cacheAccessStrategy);
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean statisticsEnabled = statistics.isStatisticsEnabled();
        if (id != null) {
            if (statisticsEnabled) {
                statistics.naturalIdCacheHit(StatsHelper.getRootEntityRole(persister), cacheAccessStrategy.getRegion().getName());
            }
            if (NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.isTraceEnabled()) {
                NaturalIdLogging.NATURAL_ID_MESSAGE_LOGGER.foundNaturalIdInSecondLevelCache(naturalId, id, persister.getRootEntityName());
            }
            this.storeInResolutionCache(resolutionCache, persister, id, cachedNaturalId);
            return id;
        }
        if (statisticsEnabled) {
            statistics.naturalIdCacheMiss(StatsHelper.getRootEntityRole(persister), cacheAccessStrategy.getRegion().getName());
        }
        return null;
    }

    private void storeInResolutionCache(EntityResolutions resolutionCache, EntityPersister persister, Object pk, Resolution cachedNaturalId) {
        EntityResolutions existingCache;
        if (resolutionCache == null && (existingCache = this.resolutionsByEntity.putIfAbsent(persister, resolutionCache = new EntityResolutions(persister, this.persistenceContext))) != null) {
            resolutionCache = existingCache;
        }
        resolutionCache.pkToNaturalIdMap.put(pk, cachedNaturalId);
        resolutionCache.naturalIdToPkMap.put(cachedNaturalId, pk);
    }

    @Override
    public Collection<?> getCachedPkResolutions(EntityMappingType entityDescriptor) {
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        if (entityNaturalIdResolutionCache != null) {
            Set<Object> pks = entityNaturalIdResolutionCache.pkToNaturalIdMap.keySet();
            return pks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(pks);
        }
        return Collections.emptyList();
    }

    public void stashInvalidNaturalIdReference(EntityPersister persister, Object invalidNaturalIdValues) {
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister = this.locatePersisterForKey(persister));
        if (entityNaturalIdResolutionCache == null) {
            throw new AssertionFailure("Expecting NaturalIdResolutionCache to exist already for entity " + persister.getEntityName());
        }
        entityNaturalIdResolutionCache.stashInvalidNaturalIdReference(invalidNaturalIdValues);
    }

    public void unStashInvalidNaturalIdReferences() {
        for (EntityResolutions naturalIdResolutionCache : this.resolutionsByEntity.values()) {
            naturalIdResolutionCache.unStashInvalidNaturalIdReferences();
        }
    }

    public void clear() {
        this.resolutionsByEntity.clear();
    }

    private static class EntityResolutions
    implements Serializable {
        private final PersistenceContext persistenceContext;
        private final EntityMappingType entityDescriptor;
        private final Map<Object, Resolution> pkToNaturalIdMap = new ConcurrentHashMap<Object, Resolution>();
        private final Map<Resolution, Object> naturalIdToPkMap = new ConcurrentHashMap<Resolution, Object>();
        private List<Resolution> invalidNaturalIdList;

        private EntityResolutions(EntityMappingType entityDescriptor, PersistenceContext persistenceContext) {
            this.entityDescriptor = entityDescriptor;
            this.persistenceContext = persistenceContext;
        }

        public EntityMappingType getEntityDescriptor() {
            return this.entityDescriptor;
        }

        public EntityPersister getPersister() {
            return this.getEntityDescriptor().getEntityPersister();
        }

        public boolean sameAsCached(Object pk, Object naturalIdValues) {
            if (pk == null) {
                return false;
            }
            Resolution initial = this.pkToNaturalIdMap.get(pk);
            return initial != null && initial.isSame(naturalIdValues);
        }

        public boolean cache(Object pk, Object naturalIdValues) {
            if (pk == null) {
                return false;
            }
            Resolution initial = this.pkToNaturalIdMap.get(pk);
            if (initial != null) {
                if (initial.isSame(naturalIdValues)) {
                    return false;
                }
                this.naturalIdToPkMap.remove(initial);
            }
            ResolutionImpl cachedNaturalId = new ResolutionImpl(this.getEntityDescriptor(), naturalIdValues, this.persistenceContext);
            this.pkToNaturalIdMap.put(pk, cachedNaturalId);
            this.naturalIdToPkMap.put(cachedNaturalId, pk);
            return true;
        }

        public void stashInvalidNaturalIdReference(Object invalidNaturalIdValues) {
            if (this.invalidNaturalIdList == null) {
                this.invalidNaturalIdList = new ArrayList<Resolution>();
            }
            this.invalidNaturalIdList.add(new ResolutionImpl(this.getEntityDescriptor(), invalidNaturalIdValues, this.persistenceContext));
        }

        public boolean containsInvalidNaturalIdReference(Object naturalIdValues) {
            return this.invalidNaturalIdList != null && this.invalidNaturalIdList.contains(new ResolutionImpl(this.getEntityDescriptor(), naturalIdValues, this.persistenceContext));
        }

        public void unStashInvalidNaturalIdReferences() {
            if (this.invalidNaturalIdList != null) {
                this.invalidNaturalIdList.clear();
            }
        }
    }

    private static class ResolutionImpl
    implements Resolution,
    Serializable {
        private final PersistenceContext persistenceContext;
        private final EntityMappingType entityDescriptor;
        private final Object naturalIdValue;
        private final int hashCode;

        public ResolutionImpl(EntityMappingType entityDescriptor, Object naturalIdValue, PersistenceContext persistenceContext) {
            this.entityDescriptor = entityDescriptor;
            this.naturalIdValue = naturalIdValue;
            this.persistenceContext = persistenceContext;
            int prime = 31;
            int hashCodeCalculation = 1;
            hashCodeCalculation = 31 * hashCodeCalculation + entityDescriptor.hashCode();
            this.hashCode = hashCodeCalculation = 31 * hashCodeCalculation + entityDescriptor.getNaturalIdMapping().calculateHashCode(naturalIdValue);
        }

        @Override
        public Object getNaturalIdValue() {
            return this.naturalIdValue;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResolutionImpl)) {
                return false;
            }
            ResolutionImpl other = (ResolutionImpl)obj;
            return this.entityDescriptor.equals(other.entityDescriptor) && this.isSame(other.naturalIdValue);
        }

        @Override
        public boolean isSame(Object otherValue) {
            return this.entityDescriptor.getNaturalIdMapping().areEqual(this.naturalIdValue, otherValue, this.persistenceContext.getSession());
        }
    }
}

