/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.print.CustomMediaSizeName;
import sun.print.DialogOwner;
import sun.print.PeekGraphics;
import sun.print.ProxyPrintGraphics;
import sun.print.SunMinMaxPage;
import sun.print.SunPageSelection;

public class PrintJob2D
extends PrintJob
implements Printable,
Runnable {
    private static final PageAttributes.MediaType[] SIZES = new PageAttributes.MediaType[]{PageAttributes.MediaType.ISO_4A0, PageAttributes.MediaType.ISO_2A0, PageAttributes.MediaType.ISO_A0, PageAttributes.MediaType.ISO_A1, PageAttributes.MediaType.ISO_A2, PageAttributes.MediaType.ISO_A3, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A5, PageAttributes.MediaType.ISO_A6, PageAttributes.MediaType.ISO_A7, PageAttributes.MediaType.ISO_A8, PageAttributes.MediaType.ISO_A9, PageAttributes.MediaType.ISO_A10, PageAttributes.MediaType.ISO_B0, PageAttributes.MediaType.ISO_B1, PageAttributes.MediaType.ISO_B2, PageAttributes.MediaType.ISO_B3, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.ISO_B5, PageAttributes.MediaType.ISO_B6, PageAttributes.MediaType.ISO_B7, PageAttributes.MediaType.ISO_B8, PageAttributes.MediaType.ISO_B9, PageAttributes.MediaType.ISO_B10, PageAttributes.MediaType.JIS_B0, PageAttributes.MediaType.JIS_B1, PageAttributes.MediaType.JIS_B2, PageAttributes.MediaType.JIS_B3, PageAttributes.MediaType.JIS_B4, PageAttributes.MediaType.JIS_B5, PageAttributes.MediaType.JIS_B6, PageAttributes.MediaType.JIS_B7, PageAttributes.MediaType.JIS_B8, PageAttributes.MediaType.JIS_B9, PageAttributes.MediaType.JIS_B10, PageAttributes.MediaType.ISO_C0, PageAttributes.MediaType.ISO_C1, PageAttributes.MediaType.ISO_C2, PageAttributes.MediaType.ISO_C3, PageAttributes.MediaType.ISO_C4, PageAttributes.MediaType.ISO_C5, PageAttributes.MediaType.ISO_C6, PageAttributes.MediaType.ISO_C7, PageAttributes.MediaType.ISO_C8, PageAttributes.MediaType.ISO_C9, PageAttributes.MediaType.ISO_C10, PageAttributes.MediaType.ISO_DESIGNATED_LONG, PageAttributes.MediaType.EXECUTIVE, PageAttributes.MediaType.FOLIO, PageAttributes.MediaType.INVOICE, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_LEGAL, PageAttributes.MediaType.QUARTO, PageAttributes.MediaType.A, PageAttributes.MediaType.B, PageAttributes.MediaType.C, PageAttributes.MediaType.D, PageAttributes.MediaType.E, PageAttributes.MediaType.NA_10X15_ENVELOPE, PageAttributes.MediaType.NA_10X14_ENVELOPE, PageAttributes.MediaType.NA_10X13_ENVELOPE, PageAttributes.MediaType.NA_9X12_ENVELOPE, PageAttributes.MediaType.NA_9X11_ENVELOPE, PageAttributes.MediaType.NA_7X9_ENVELOPE, PageAttributes.MediaType.NA_6X9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_10_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_11_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_12_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_14_ENVELOPE, PageAttributes.MediaType.INVITE_ENVELOPE, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.MONARCH_ENVELOPE, PageAttributes.MediaType.PERSONAL_ENVELOPE};
    private static final MediaSizeName[] JAVAXSIZES = new MediaSizeName[]{null, null, MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, null, null, null, null, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.EXECUTIVE, MediaSizeName.FOLIO, MediaSizeName.INVOICE, MediaSizeName.LEDGER, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.QUARTO, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, null, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE};
    private static final int[] WIDTHS = new int[]{4768, 3370, 2384, 1684, 1191, 842, 595, 420, 298, 210, 147, 105, 74, 2835, 2004, 1417, 1001, 709, 499, 354, 249, 176, 125, 88, 2920, 2064, 1460, 1032, 729, 516, 363, 258, 181, 128, 91, 2599, 1837, 1298, 918, 649, 459, 323, 230, 162, 113, 79, 312, 522, 612, 396, 792, 612, 612, 609, 612, 792, 1224, 1584, 2448, 720, 720, 720, 648, 648, 504, 432, 279, 297, 324, 342, 360, 624, 312, 279, 261};
    private static final int[] LENGTHS = new int[]{6741, 4768, 3370, 2384, 1684, 1191, 842, 595, 420, 298, 210, 147, 105, 4008, 2835, 2004, 1417, 1001, 729, 499, 354, 249, 176, 125, 4127, 2920, 2064, 1460, 1032, 729, 516, 363, 258, 181, 128, 3677, 2599, 1837, 1298, 918, 649, 459, 323, 230, 162, 113, 624, 756, 936, 612, 1224, 792, 1008, 780, 792, 1224, 1584, 2448, 3168, 1080, 1008, 936, 864, 792, 648, 648, 639, 684, 747, 792, 828, 624, 652, 540, 468};
    private Frame frame;
    private String docTitle = "";
    private JobAttributes jobAttributes;
    private PageAttributes pageAttributes;
    private PrintRequestAttributeSet attributes;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private MessageQ graphicsToBeDrawn = new MessageQ("tobedrawn");
    private MessageQ graphicsDrawn = new MessageQ("drawn");
    private Graphics2D currentGraphics;
    private int pageIndex = -1;
    private static final String DEST_PROP = "awt.print.destination";
    private static final String PRINTER = "printer";
    private static final String FILE = "file";
    private static final String PRINTER_PROP = "awt.print.printer";
    private static final String FILENAME_PROP = "awt.print.fileName";
    private static final String NUMCOPIES_PROP = "awt.print.numCopies";
    private static final String OPTIONS_PROP = "awt.print.options";
    private static final String ORIENT_PROP = "awt.print.orientation";
    private static final String PORTRAIT = "portrait";
    private static final String LANDSCAPE = "landscape";
    private static final String PAPERSIZE_PROP = "awt.print.paperSize";
    private static final String LETTER = "letter";
    private static final String LEGAL = "legal";
    private static final String EXECUTIVE = "executive";
    private static final String A4 = "a4";
    private Properties props;
    private String options = "";
    private Thread printerJobThread;

    public PrintJob2D(Frame frame, String string, Properties properties) {
        this.props = properties;
        this.jobAttributes = new JobAttributes();
        this.pageAttributes = new PageAttributes();
        this.translateInputProps();
        this.initPrintJob2D(frame, string, this.jobAttributes, this.pageAttributes);
    }

    public PrintJob2D(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        this.initPrintJob2D(frame, string, jobAttributes, pageAttributes);
    }

    private void initPrintJob2D(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (frame == null && (jobAttributes == null || jobAttributes.getDialog() == JobAttributes.DialogType.NATIVE)) {
            throw new NullPointerException("Frame must not be null");
        }
        this.frame = frame;
        this.docTitle = string == null ? "" : string;
        this.jobAttributes = jobAttributes != null ? jobAttributes : new JobAttributes();
        this.pageAttributes = pageAttributes != null ? pageAttributes : new PageAttributes();
        int[][] nArray = this.jobAttributes.getPageRanges();
        int n = nArray[0][0];
        int n2 = nArray[nArray.length - 1][1];
        this.jobAttributes.setPageRanges(new int[][]{{n, n2}});
        this.jobAttributes.setToPage(n2);
        this.jobAttributes.setFromPage(n);
        int[] nArray2 = this.pageAttributes.getPrinterResolution();
        if (nArray2[0] != nArray2[1]) {
            throw new IllegalArgumentException("Differing cross feed and feed resolutions not supported.");
        }
        JobAttributes.DestinationType destinationType = this.jobAttributes.getDestination();
        if (destinationType == JobAttributes.DestinationType.FILE) {
            this.throwPrintToFile();
            String string2 = jobAttributes.getFileName();
            if (string2 != null && jobAttributes.getDialog() == JobAttributes.DialogType.NONE) {
                File file = new File(string2);
                try {
                    if (file.createNewFile()) {
                        file.delete();
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Cannot write to file:" + string2);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                File file2 = file.getParentFile();
                if (file.exists() && (!file.isFile() || !file.canWrite()) || file2 != null && (!file2.exists() || file2.exists() && !file2.canWrite())) {
                    throw new IllegalArgumentException("Cannot write to file:" + string2);
                }
            }
        }
    }

    public boolean printDialog() {
        boolean bl = false;
        this.printerJob = PrinterJob.getPrinterJob();
        if (this.printerJob == null) {
            return false;
        }
        JobAttributes.DialogType dialogType = this.jobAttributes.getDialog();
        PrintService printService = this.printerJob.getPrintService();
        if (printService == null && dialogType == JobAttributes.DialogType.NONE) {
            return false;
        }
        this.copyAttributes(printService);
        JobAttributes.DefaultSelectionType defaultSelectionType = this.jobAttributes.getDefaultSelection();
        if (defaultSelectionType == JobAttributes.DefaultSelectionType.RANGE) {
            this.attributes.add(SunPageSelection.RANGE);
        } else if (defaultSelectionType == JobAttributes.DefaultSelectionType.SELECTION) {
            this.attributes.add(SunPageSelection.SELECTION);
        } else {
            this.attributes.add(SunPageSelection.ALL);
        }
        if (this.frame != null) {
            this.attributes.add(new DialogOwner(this.frame));
        }
        if (dialogType == JobAttributes.DialogType.NONE) {
            bl = true;
        } else {
            if (dialogType == JobAttributes.DialogType.NATIVE) {
                this.attributes.add(DialogTypeSelection.NATIVE);
            } else {
                this.attributes.add(DialogTypeSelection.COMMON);
            }
            bl = this.printerJob.printDialog(this.attributes);
            if (bl) {
                if (printService == null && (printService = this.printerJob.getPrintService()) == null) {
                    return false;
                }
                this.updateAttributes();
                this.translateOutputProps();
            }
        }
        if (bl) {
            JobName jobName = (JobName)this.attributes.get(JobName.class);
            if (jobName != null) {
                this.printerJob.setJobName(jobName.toString());
            }
            this.pageFormat = new PageFormat();
            Media media = (Media)this.attributes.get(Media.class);
            MediaSize mediaSize = null;
            if (media != null && media instanceof MediaSizeName) {
                mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
            }
            Paper paper = this.pageFormat.getPaper();
            if (mediaSize != null) {
                paper.setSize((double)mediaSize.getX(25400) * 72.0, (double)mediaSize.getY(25400) * 72.0);
            }
            if (this.pageAttributes.getOrigin() == PageAttributes.OriginType.PRINTABLE) {
                paper.setImageableArea(18.0, 18.0, paper.getWidth() - 36.0, paper.getHeight() - 36.0);
            } else {
                paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            }
            this.pageFormat.setPaper(paper);
            OrientationRequested orientationRequested = (OrientationRequested)this.attributes.get(OrientationRequested.class);
            if (orientationRequested != null && orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                this.pageFormat.setOrientation(2);
            } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                this.pageFormat.setOrientation(0);
            } else {
                this.pageFormat.setOrientation(1);
            }
            this.printerJob.setPrintable(this, this.pageFormat);
        }
        return bl;
    }

    private void updateAttributes() {
        PageAttributes.MediaType mediaType;
        Copies copies = (Copies)this.attributes.get(Copies.class);
        this.jobAttributes.setCopies(copies.getValue());
        SunPageSelection sunPageSelection = (SunPageSelection)this.attributes.get(SunPageSelection.class);
        if (sunPageSelection == SunPageSelection.RANGE) {
            this.jobAttributes.setDefaultSelection(JobAttributes.DefaultSelectionType.RANGE);
        } else if (sunPageSelection == SunPageSelection.SELECTION) {
            this.jobAttributes.setDefaultSelection(JobAttributes.DefaultSelectionType.SELECTION);
        } else {
            this.jobAttributes.setDefaultSelection(JobAttributes.DefaultSelectionType.ALL);
        }
        Destination destination = (Destination)this.attributes.get(Destination.class);
        if (destination != null) {
            this.jobAttributes.setDestination(JobAttributes.DestinationType.FILE);
            this.jobAttributes.setFileName(destination.getURI().getPath());
        } else {
            this.jobAttributes.setDestination(JobAttributes.DestinationType.PRINTER);
        }
        PrintService printService = this.printerJob.getPrintService();
        if (printService != null) {
            this.jobAttributes.setPrinter(printService.getName());
        }
        PageRanges pageRanges = (PageRanges)this.attributes.get(PageRanges.class);
        int[][] nArray = pageRanges.getMembers();
        this.jobAttributes.setPageRanges(nArray);
        SheetCollate sheetCollate = (SheetCollate)this.attributes.get(SheetCollate.class);
        if (sheetCollate == SheetCollate.COLLATED) {
            this.jobAttributes.setMultipleDocumentHandling(JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES);
        } else {
            this.jobAttributes.setMultipleDocumentHandling(JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
        }
        Sides sides = (Sides)this.attributes.get(Sides.class);
        if (sides == Sides.TWO_SIDED_LONG_EDGE) {
            this.jobAttributes.setSides(JobAttributes.SidesType.TWO_SIDED_LONG_EDGE);
        } else if (sides == Sides.TWO_SIDED_SHORT_EDGE) {
            this.jobAttributes.setSides(JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE);
        } else {
            this.jobAttributes.setSides(JobAttributes.SidesType.ONE_SIDED);
        }
        Chromaticity chromaticity = (Chromaticity)this.attributes.get(Chromaticity.class);
        if (chromaticity == Chromaticity.COLOR) {
            this.pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        } else {
            this.pageAttributes.setColor(PageAttributes.ColorType.MONOCHROME);
        }
        OrientationRequested orientationRequested = (OrientationRequested)this.attributes.get(OrientationRequested.class);
        if (orientationRequested == OrientationRequested.LANDSCAPE) {
            this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.LANDSCAPE);
        } else {
            this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
        }
        PrintQuality printQuality = (PrintQuality)this.attributes.get(PrintQuality.class);
        if (printQuality == PrintQuality.DRAFT) {
            this.pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.DRAFT);
        } else if (printQuality == PrintQuality.HIGH) {
            this.pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        } else {
            this.pageAttributes.setPrintQuality(PageAttributes.PrintQualityType.NORMAL);
        }
        Media media = (Media)this.attributes.get(Media.class);
        if (media != null && media instanceof MediaSizeName && (mediaType = PrintJob2D.unMapMedia((MediaSizeName)media)) != null) {
            this.pageAttributes.setMedia(mediaType);
        }
        this.debugPrintAttributes(false, false);
    }

    private void debugPrintAttributes(boolean bl, boolean bl2) {
        if (bl) {
            System.out.println("new Attributes\ncopies = " + this.jobAttributes.getCopies() + "\nselection = " + this.jobAttributes.getDefaultSelection() + "\ndest " + this.jobAttributes.getDestination() + "\nfile " + this.jobAttributes.getFileName() + "\nfromPage " + this.jobAttributes.getFromPage() + "\ntoPage " + this.jobAttributes.getToPage() + "\ncollation " + this.jobAttributes.getMultipleDocumentHandling() + "\nPrinter " + this.jobAttributes.getPrinter() + "\nSides2 " + this.jobAttributes.getSides());
        }
        if (bl2) {
            System.out.println("new Attributes\ncolor = " + this.pageAttributes.getColor() + "\norientation = " + this.pageAttributes.getOrientationRequested() + "\nquality " + this.pageAttributes.getPrintQuality() + "\nMedia2 " + this.pageAttributes.getMedia());
        }
    }

    private void copyAttributes(PrintService printService) {
        PageAttributes.PrintQualityType printQualityType;
        Object object;
        Object object2;
        PrintService[] printServiceArray;
        this.attributes = new HashPrintRequestAttributeSet();
        this.attributes.add(new JobName(this.docTitle, null));
        PrintService printService2 = printService;
        String string = this.jobAttributes.getPrinter();
        if (string != null && string != "" && !string.equals(printService2.getName())) {
            printServiceArray = PrinterJob.lookupPrintServices();
            try {
                for (int i = 0; i < printServiceArray.length; ++i) {
                    if (!string.equals(printServiceArray[i].getName())) continue;
                    this.printerJob.setPrintService(printServiceArray[i]);
                    printService2 = printServiceArray[i];
                    break;
                }
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
        if ((printServiceArray = this.jobAttributes.getDestination()) == JobAttributes.DestinationType.FILE && printService2.isAttributeCategorySupported(Destination.class)) {
            String string2 = this.jobAttributes.getFileName();
            if (string2 == null && (object2 = (Destination)printService2.getDefaultAttributeValue(Destination.class)) != null) {
                this.attributes.add((Attribute)object2);
            } else {
                object = null;
                try {
                    if (string2 != null) {
                        if (string2.equals("")) {
                            string2 = ".";
                        }
                    } else {
                        string2 = "out.prn";
                    }
                    object = new File(string2).toURI();
                }
                catch (SecurityException securityException) {
                    try {
                        string2 = string2.replace('\\', '/');
                        object = new URI("file:" + string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    this.attributes.add(new Destination((URI)object));
                }
            }
        }
        this.attributes.add(new SunMinMaxPage(this.jobAttributes.getMinPage(), this.jobAttributes.getMaxPage()));
        JobAttributes.SidesType sidesType = this.jobAttributes.getSides();
        if (sidesType == JobAttributes.SidesType.TWO_SIDED_LONG_EDGE) {
            this.attributes.add(Sides.TWO_SIDED_LONG_EDGE);
        } else if (sidesType == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE) {
            this.attributes.add(Sides.TWO_SIDED_SHORT_EDGE);
        } else if (sidesType == JobAttributes.SidesType.ONE_SIDED) {
            this.attributes.add(Sides.ONE_SIDED);
        }
        object2 = this.jobAttributes.getMultipleDocumentHandling();
        if (object2 == JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES) {
            this.attributes.add(SheetCollate.COLLATED);
        } else {
            this.attributes.add(SheetCollate.UNCOLLATED);
        }
        this.attributes.add(new Copies(this.jobAttributes.getCopies()));
        this.attributes.add(new PageRanges(this.jobAttributes.getFromPage(), this.jobAttributes.getToPage()));
        if (this.pageAttributes.getColor() == PageAttributes.ColorType.COLOR) {
            this.attributes.add(Chromaticity.COLOR);
        } else {
            this.attributes.add(Chromaticity.MONOCHROME);
        }
        this.pageFormat = this.printerJob.defaultPage();
        if (this.pageAttributes.getOrientationRequested() == PageAttributes.OrientationRequestedType.LANDSCAPE) {
            this.pageFormat.setOrientation(0);
            this.attributes.add(OrientationRequested.LANDSCAPE);
        } else {
            this.pageFormat.setOrientation(1);
            this.attributes.add(OrientationRequested.PORTRAIT);
        }
        object = this.pageAttributes.getMedia();
        MediaSizeName mediaSizeName = PrintJob2D.mapMedia((PageAttributes.MediaType)object);
        if (mediaSizeName != null) {
            this.attributes.add(mediaSizeName);
        }
        if ((printQualityType = this.pageAttributes.getPrintQuality()) == PageAttributes.PrintQualityType.DRAFT) {
            this.attributes.add(PrintQuality.DRAFT);
        } else if (printQualityType == PageAttributes.PrintQualityType.NORMAL) {
            this.attributes.add(PrintQuality.NORMAL);
        } else if (printQualityType == PageAttributes.PrintQualityType.HIGH) {
            this.attributes.add(PrintQuality.HIGH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graphics getGraphics() {
        ProxyPrintGraphics proxyPrintGraphics = null;
        PrintJob2D printJob2D = this;
        synchronized (printJob2D) {
            ++this.pageIndex;
            if (this.pageIndex == 0 && !this.graphicsToBeDrawn.isClosed()) {
                this.startPrinterJobThread();
            }
            this.notify();
        }
        if (this.currentGraphics != null) {
            this.graphicsDrawn.append(this.currentGraphics);
            this.currentGraphics = null;
        }
        this.currentGraphics = this.graphicsToBeDrawn.pop();
        if (this.currentGraphics instanceof PeekGraphics) {
            ((PeekGraphics)this.currentGraphics).setAWTDrawingOnly();
            this.graphicsDrawn.append(this.currentGraphics);
            this.currentGraphics = this.graphicsToBeDrawn.pop();
        }
        if (this.currentGraphics != null) {
            this.currentGraphics.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
            double d = 72.0 / this.getPageResolutionInternal();
            this.currentGraphics.scale(d, d);
            proxyPrintGraphics = new ProxyPrintGraphics(this.currentGraphics.create(), this);
        }
        return proxyPrintGraphics;
    }

    @Override
    public Dimension getPageDimension() {
        double d;
        double d2;
        if (this.pageAttributes != null && this.pageAttributes.getOrigin() == PageAttributes.OriginType.PRINTABLE) {
            d2 = this.pageFormat.getImageableWidth();
            d = this.pageFormat.getImageableHeight();
        } else {
            d2 = this.pageFormat.getWidth();
            d = this.pageFormat.getHeight();
        }
        double d3 = this.getPageResolutionInternal() / 72.0;
        return new Dimension((int)(d2 * d3), (int)(d * d3));
    }

    private double getPageResolutionInternal() {
        if (this.pageAttributes != null) {
            int[] nArray = this.pageAttributes.getPrinterResolution();
            if (nArray[2] == 3) {
                return nArray[0];
            }
            return (double)nArray[0] * 2.54;
        }
        return 72.0;
    }

    @Override
    public int getPageResolution() {
        return (int)this.getPageResolutionInternal();
    }

    @Override
    public boolean lastPageFirst() {
        return false;
    }

    @Override
    public synchronized void end() {
        this.graphicsToBeDrawn.close();
        if (this.currentGraphics != null) {
            this.graphicsDrawn.append(this.currentGraphics);
        }
        this.graphicsDrawn.closeWhenEmpty();
        if (this.printerJobThread != null && this.printerJobThread.isAlive()) {
            try {
                this.printerJobThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void finalize() {
        this.end();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.graphicsToBeDrawn.append((Graphics2D)graphics);
        int n2 = this.graphicsDrawn.pop() != null ? 0 : 1;
        return n2;
    }

    private void startPrinterJobThread() {
        this.printerJobThread = new Thread((Runnable)this, "printerJobThread");
        this.printerJobThread.start();
    }

    @Override
    public void run() {
        try {
            this.printerJob.print(this.attributes);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        this.graphicsToBeDrawn.closeWhenEmpty();
        this.graphicsDrawn.close();
    }

    private static int[] getSize(PageAttributes.MediaType mediaType) {
        int[] nArray = new int[]{612, 792};
        for (int i = 0; i < SIZES.length; ++i) {
            if (SIZES[i] != mediaType) continue;
            nArray[0] = WIDTHS[i];
            nArray[1] = LENGTHS[i];
            break;
        }
        return nArray;
    }

    public static MediaSizeName mapMedia(PageAttributes.MediaType mediaType) {
        MediaSizeName mediaSizeName = null;
        int n = Math.min(SIZES.length, JAVAXSIZES.length);
        for (int i = 0; i < n; ++i) {
            if (SIZES[i] != mediaType) continue;
            if (JAVAXSIZES[i] != null && MediaSize.getMediaSizeForName(JAVAXSIZES[i]) != null) {
                mediaSizeName = JAVAXSIZES[i];
                break;
            }
            mediaSizeName = new CustomMediaSizeName(SIZES[i].toString());
            float f = (float)Math.rint((double)WIDTHS[i] / 72.0);
            float f2 = (float)Math.rint((double)LENGTHS[i] / 72.0);
            if (!((double)f > 0.0) || !((double)f2 > 0.0)) break;
            new MediaSize(f, f2, 25400, mediaSizeName);
            break;
        }
        return mediaSizeName;
    }

    public static PageAttributes.MediaType unMapMedia(MediaSizeName mediaSizeName) {
        PageAttributes.MediaType mediaType = null;
        int n = Math.min(SIZES.length, JAVAXSIZES.length);
        for (int i = 0; i < n; ++i) {
            if (JAVAXSIZES[i] != mediaSizeName || SIZES[i] == null) continue;
            mediaType = SIZES[i];
            break;
        }
        return mediaType;
    }

    private void translateInputProps() {
        if (this.props == null) {
            return;
        }
        String string = this.props.getProperty(DEST_PROP);
        if (string != null) {
            if (string.equals(PRINTER)) {
                this.jobAttributes.setDestination(JobAttributes.DestinationType.PRINTER);
            } else if (string.equals(FILE)) {
                this.jobAttributes.setDestination(JobAttributes.DestinationType.FILE);
            }
        }
        if ((string = this.props.getProperty(PRINTER_PROP)) != null) {
            this.jobAttributes.setPrinter(string);
        }
        if ((string = this.props.getProperty(FILENAME_PROP)) != null) {
            this.jobAttributes.setFileName(string);
        }
        if ((string = this.props.getProperty(NUMCOPIES_PROP)) != null) {
            this.jobAttributes.setCopies(Integer.parseInt(string));
        }
        this.options = this.props.getProperty(OPTIONS_PROP, "");
        string = this.props.getProperty(ORIENT_PROP);
        if (string != null) {
            if (string.equals(PORTRAIT)) {
                this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
            } else if (string.equals(LANDSCAPE)) {
                this.pageAttributes.setOrientationRequested(PageAttributes.OrientationRequestedType.LANDSCAPE);
            }
        }
        if ((string = this.props.getProperty(PAPERSIZE_PROP)) != null) {
            if (string.equals(LETTER)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.LETTER.hashCode()]);
            } else if (string.equals(LEGAL)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.LEGAL.hashCode()]);
            } else if (string.equals(EXECUTIVE)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.EXECUTIVE.hashCode()]);
            } else if (string.equals(A4)) {
                this.pageAttributes.setMedia(SIZES[PageAttributes.MediaType.A4.hashCode()]);
            }
        }
    }

    private void translateOutputProps() {
        int n;
        if (this.props == null) {
            return;
        }
        this.props.setProperty(DEST_PROP, this.jobAttributes.getDestination() == JobAttributes.DestinationType.PRINTER ? PRINTER : FILE);
        String string = this.jobAttributes.getPrinter();
        if (string != null && !string.equals("")) {
            this.props.setProperty(PRINTER_PROP, string);
        }
        if ((string = this.jobAttributes.getFileName()) != null && !string.equals("")) {
            this.props.setProperty(FILENAME_PROP, string);
        }
        if ((n = this.jobAttributes.getCopies()) > 0) {
            this.props.setProperty(NUMCOPIES_PROP, "" + n);
        }
        if ((string = this.options) != null && !string.equals("")) {
            this.props.setProperty(OPTIONS_PROP, string);
        }
        this.props.setProperty(ORIENT_PROP, this.pageAttributes.getOrientationRequested() == PageAttributes.OrientationRequestedType.PORTRAIT ? PORTRAIT : LANDSCAPE);
        PageAttributes.MediaType mediaType = SIZES[this.pageAttributes.getMedia().hashCode()];
        string = mediaType == PageAttributes.MediaType.LETTER ? LETTER : (mediaType == PageAttributes.MediaType.LEGAL ? LEGAL : (mediaType == PageAttributes.MediaType.EXECUTIVE ? EXECUTIVE : (mediaType == PageAttributes.MediaType.A4 ? A4 : mediaType.toString())));
        this.props.setProperty(PAPERSIZE_PROP, string);
    }

    private void throwPrintToFile() {
        SecurityManager securityManager = System.getSecurityManager();
        FilePermission filePermission = null;
        if (securityManager != null) {
            if (filePermission == null) {
                filePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            securityManager.checkPermission(filePermission);
        }
    }

    private class MessageQ {
        private String qid = "noname";
        private ArrayList queue = new ArrayList();

        MessageQ(String string) {
            this.qid = string;
        }

        synchronized void closeWhenEmpty() {
            while (this.queue != null && this.queue.size() > 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.queue = null;
            this.notifyAll();
        }

        synchronized void close() {
            this.queue = null;
            this.notifyAll();
        }

        synchronized boolean append(Graphics2D graphics2D) {
            boolean bl = false;
            if (this.queue != null) {
                this.queue.add(graphics2D);
                bl = true;
                this.notify();
            }
            return bl;
        }

        synchronized Graphics2D pop() {
            Graphics2D graphics2D = null;
            while (graphics2D == null && this.queue != null) {
                if (this.queue.size() > 0) {
                    graphics2D = (Graphics2D)this.queue.remove(0);
                    this.notify();
                    continue;
                }
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return graphics2D;
        }

        synchronized boolean isClosed() {
            return this.queue == null;
        }
    }
}

