---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: エピックを管理する
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

このページでは、[エピック](_index.md)に関して、またはエピックに関連して実行できるすべての操作について説明します。

## エピックを作成する {#create-an-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。
- マイルストーンをエピックに割り当てる機能が、GitLab 18.2で[導入](https://gitlab.com/groups/gitlab-org/-/epics/329)されました。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

所属するグループにエピックを作成するには:

1. 新しいエピックフォームに移動します:
   - グループに移動し、左側のサイドバーから**エピック**を選択します。次に、**新しいエピック**を選択します。
   - グループ内のエピックから、右上隅にある**追加のアクション** ({{< icon name="ellipsis_v" >}}) を選択します。次に、**New related epic**（新しい関連エピック）を選択します。
   - 任意の場所で、上部のメニューの**新しい**（{{< icon name="plus-square" >}}）を選択します。次に、**新しいエピック**を選択します。
   - 空の[ロードマップ](../roadmap/_index.md)で、**新しいエピック**を選択します。

1. タイトルを入力します。
1. フィールドに入力します。
   - 説明を入力します。
   - [エピックを非公開にする](#make-an-epic-confidential)には、**非公開に設定**の横にあるチェックボックスをオンにします。
   - ラベルを選択します。
   - 開始日と期限を選択するか、開始日と期限を[継承](#start-and-due-date-inheritance)します。
   - [色](#epic-color)を選択します。
1. **エピックを作成**を選択します。

新しく作成されたエピックが開きます。

### 開始日と期限の継承 {#start-and-due-date-inheritance}

**継承**を選択した場合: 

- **start date**（開始日）の場合: GitLabは、エピックに割り当てられたすべての子エピックとイシューをスキャンし、子エピックまたは子アイテムに割り当てられたマイルストーンで最初に見つかった最も早い開始日に一致するように開始日を設定します。
- **due date**（期限）の場合: GitLabは、エピックに割り当てられたすべての子エピックとイシューをスキャンし、子エピックまたは子アイテムに割り当てられたマイルストーンで見つかった最も遅い期限に一致するように期限を設定します。

これらの日付は動的であり、次のいずれかが発生した場合は再計算されます:

- 子エピックの日付が変更される。
- マイルストーンがイシューに再アサインされる。
- マイルストーンの日付が変更される。
- イシューがエピックに追加またはエピックから削除される。

エピックの日付は子から日付を継承できるため、開始日と期限は下から上に伝播します。最下位の子エピックの開始日が変更された場合、それが親エピックの最も早い開始日の候補になります。次に、親エピックの開始日はこの変更を反映し、最上位のエピックに上方伝播します。

## エピックを編集する {#edit-an-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

エピックを作成した後、次の詳細を編集できます:

- タイトル
- 説明
- 開始日
- 期限
- ラベル
- マイルストーン
- [色](#epic-color)

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックのタイトルまたは説明を編集するには: 

1. **編集**を選択します。
1. 変更を加えます。
1. **変更を保存**を選択します。

エピックの開始日、期限、マイルストーン、またはラベルを編集するには、次のようにします:

1. 右側のサイドバーの各セクションの横にある**編集**を選択します。
1. エピックの日付、マイルストーン、またはラベルを選択します。

### エピックの説明にあるリスト項目を並べ替える {#reorder-list-items-in-the-epic-description}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

説明にリストがあるエピックを表示するときに、リスト項目を並べ替えることもできます。

前提要件:

- プロジェクトのプランナーロール以上を持っているか、エピックの作成者であるか、エピックの担当者である必要があります。
- エピックの説明には、[順序付き、順序なし](../../markdown.md#lists) 、または[タスク](../../markdown.md#task-lists)リストが必要です。

エピックを表示するときにリスト項目を並べ替えるには: 

1. リスト項目の行にカーソルを合わせ、グリップアイコン（{{< icon name="grip" >}}）を表示します。
1. グリップアイコンを選択して保持します。
1. 行をリストの新しい位置にドラッグします。
1. グリップアイコンをリリースします。

### エピックを一括で編集する {#bulk-edit-epics}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。
- GitLab 18.3で、より多くの一括編集属性が[追加されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200186)。
- GitLab 18.5で親属性の一括編集のサポートが[追加](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204037)されました。

{{< /history >}}

前提要件:

- 親エピックのグループに対してプランナーロール以上を持っている必要があります。

複数のエピックを同時に更新するには:

1. グループで、**エピック** > **リスト**に移動します。
1. **一括編集**を選択します。右側に編集可能なフィールドを含むサイドバーが表示されます。
1. 編集する各エピックの横にあるチェックボックスをオンにします。
1. サイドバーから適切なフィールドと値を選択します。
1. **選択済みアイテムを更新する**を選択します。

グループ内でエピックを一括編集する場合、次の属性を編集できます: 

- 状態（オープンまたは完了）
- [担当者](#assignees)
- [マイルストーン](../../project/milestones/_index.md)
- [ラベル](../../project/labels.md)
- [ヘルスステータス](#health-status)
- [通知](../../profile/notifications.md)サブスクリプション
- [機密性](#make-an-epic-confidential)
- [親](#add-a-parent-epic-to-an-epic)

## 「**続きを読む**」で説明が省略されるのを防ぎます。 {#prevent-truncating-descriptions-with-read-more}

{{< history >}}

- GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184)されました。

{{< /history >}}

エピックの説明が長い場合、GitLabはその一部のみを表示します。説明全体を表示するには、**続きを読む**を選択する必要があります。この切り詰める機能により、長文をスクロールせずに、ページ上の他の要素を簡単に見つけることができます。

説明を切り詰めるかどうかを変更するには:

1. エピックの右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. 好みに応じて**説明を折りたたむ**を切り替えます。

この設定は記憶され、すべてのイシュー、タスク、エピック、目標、および主な成果に影響します。

## 右側のサイドバーを非表示にする {#hide-the-right-sidebar}

{{< history >}}

- GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184)されました。

{{< /history >}}

スペースがある場合、エピックの属性は説明の右側のサイドバーに表示されます。

サイドバーを非表示にして、説明のスペースを増やすには: 

1. エピックの右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **サイドバーを非表示にする**を選択します。

この設定は記憶され、すべてのイシュー、タスク、エピック、目標、および主な成果に影響します。

サイドバーを再度表示するには: 

- 上記の手順を繰り返し、**サイドバーを表示する**を選択します。

## 担当者 {#assignees}

{{< details >}}

- 提供形態: GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.4で`work_items_beta`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/4231)されました。デフォルトでは無効になっています。この機能は[ベータ版](../../../policy/development_stages_support.md#beta)です。
- GitLab 18.2で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/551805)になりました。機能フラグ`work_items_beta`の背後から移動しました。

{{< /history >}}

1つまたは複数のユーザーにエピックを割り当てることができます。

担当者は必要に応じて何度でも変更できます。担当者はエピックの責任者であるという考え方です。

ユーザーがグループのメンバーでない場合、別のグループメンバーがエピックを割り当てる場合のみ、エピックをそのユーザーに割り当てることができます。

### エピックの担当者を変更する {#change-assignee-on-an-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- グループのプランナーロール以上を持っている必要があります。

エピックの担当者を変更するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択し、表示するエピックを選択します。
1. 右側のサイドバーの**担当者**セクションで、**編集**を選択します。
1. ドロップダウンリストから、担当者として追加するユーザーを選択します。
1. ドロップダウンリストの外側の領域を選択します。

担当者は、ページを更新しなくても変更されます。

## エピックの色 {#epic-color}

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

{{< history >}}

- GitLab 14.9で`epic_color_highlight`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79940)されました。デフォルトでは無効になっています。
- GitLab 16.11で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/365336)になりました。機能フラグ`epic_color_highlight`は削除されました。
- カスタマイズ可能な色が、GitLab 17.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/394864)されました。

{{< /history >}}

エピックの色を設定して、タスクを視覚的に分類および優先順位付けできます。色を使用して以下を行います: 

- エピックをチームまたは会社のイニシアチブに関連付ける。
- エピック階層のレベルを示す。
- 関連するエピックをグループにまとめる。

エピックの色は、[ロードマップ](../roadmap/_index.md)と[エピックボード](epic_boards.md)に表示されます。

ロードマップでは、タイムラインバーはエピックの色と一致します:

![v17.0で色分けされたエピック](img/epic_color_roadmap_v17_0.png)

エピックボードでは、色はエピックのカードアクセントに表示されます: 

![v17.0で関連付けられたエピックの色で強調表示されたカード](img/epic_accent_boards_v17_0.png)

### エピックの色を変更する {#change-an-epics-color}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックの色を変更するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。
1. **新しいエピック**を選択するか、既存のエピックを選択します。
1. 右側のサイドバーの**色**セクションで、**編集**を選択します。
1. 既存の色を選択するか、RGBまたは16進数値を入力します。
1. ダイアログの外側の領域を選択します。

エピックの色が更新されます。

## エピックを削除する {#delete-an-epic}

{{< history >}}

- GitLab 16.11で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/452189)されました。GitLab 16.10以前では、エピックを削除すると、そのすべての子エピックとその子孫も削除されます。必要に応じて、削除する前に、親エピックから[子エピックを削除](#remove-a-child-epic-from-a-parent-epic)できます。
- GitLab 17.7で、プランナーロールがエピックを削除[できるようになりました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロールまたはオーナーロールを持っている必要があります。

エピックを削除するには: 

1. 右上隅にある**追加のアクション** ({{< icon name="ellipsis_v" >}}) を選択し、**Delete epic**を選択します。
1. **削除**を選択します。確認ダイアログで、**Delete epic**（エピックを削除）を選択します。

エピックを削除すると、システム内の関連付けられているエピックから既存のすべてのイシューが解放されます。

## エピックを閉じる {#close-an-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックを閉じるには: 

- 右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**Close epic**（エピックを閉じる）を選択します。

`/close`[クイックアクション](../../project/quick_actions.md)を使用することもできます。

## 閉じたエピックを再開する {#reopen-a-closed-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

閉じたエピックを再開することができます。

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

これを行うには、次のいずれかを実行します:

- 右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**Reopen epic**（エピックを再開）を選択します。
- `/reopen`[クイックアクション](../../project/quick_actions.md)を使用します。

[イシューをプロモート](../../project/issues/managing_issues.md#promote-an-issue-to-an-epic)してエピックを作成することもできます。

## イシューからエピックに移動する {#go-to-an-epic-from-an-issue}

<!-- Update this section after flag work_item_view_for_issues is removed to refer to the Parent section in the sidebar -->

イシューがエピックに属している場合、次の場所から親エピックに移動できます:

- イシューの上部にあるパンくずリスト。
- 右側のサイドバーにある**エピック**セクション。

## エピックリストを表示する {#view-epics-list}

グループでは、左側のサイドバーにオープンエピックの合計数が表示されます。この数字は、グループとそのサブグループに関連付けられているすべてのエピックを示します。これには、表示する権限がないエピックも含まれています。

前提要件:

- 次のいずれかのメンバーである必要があります: 
  - グループ
  - グループ内のプロジェクト
  - グループのサブグループのいずれかのプロジェクト

グループ内のエピックを表示するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。

### エピックを表示できるユーザー {#who-can-view-an-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

エピックを表示できるかどうかは、[グループの表示レベル](../../public_access.md)とエピックの[公開設定](#make-an-epic-confidential)によって異なります: 

- 公開グループと機密ではないエピック: 誰でもエピックを表示できます。
- プライベートグループと機密ではないエピック: グループのゲストロール以上を持っている必要があります。
- 非公開のエピック（グループの表示レベルに関係なく）: グループのプランナーロール以上を持っている必要があります。

### エピックの表示設定を構成する {#configure-epic-display-preferences}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/393559) in GitLab 18.2.

{{< /history >}}

エピックリストでのエピックの表示方法をカスタマイズするには、特定のメタデータ属性フィールドを表示または非表示にして、表示設定を構成します。

GitLabは、異なるレベルで表示設定を保存します: 

- **フィールド**: ネームスペースごとに保存されます。お客様のワークフローのニーズに基づいて、異なるグループやプロジェクトに対して異なるフィールドの表示レベルを設定できます。たとえば、あるグループでは担当者とラベルを表示し、別のグループでは非表示にすることができます。
- **設定**: すべてのプロジェクトとグループでグローバルに保存されます。これにより、作業アイテムの表示方法の設定が常に一貫したものになります。

エピックの表示設定を構成するには、次の手順を実行します: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。
1. 右上隅で、**オプションの表示**（{{< icon name="preferences" >}}）を選択します。
1. **フィールド**で、表示するメタデータをオンまたはオフにします: 
   - **担当者**: エピックの担当者。
   - **ラベル**: エピックのラベル。
   - **マイルストーン**: マイルストーン情報。
   - **日付**: 期限と日付の範囲。
   - **健全性**: ヘルスステータスインジケーター。
   - **ブロック済み/ブロック中**: ブロック関係インジケーター。
   - **コメント**: コメント数。
   - **人気度**: 人気度のメトリック。
1. **設定**で、**サイドパネルにアイテムを開く**をオンまたはオフにして、エピックを選択したときにエピックをどのように開くかを選択します: 
   - オン（デフォルト）: エピックが画面の右側のドロワーで開きます。
   - オフ: エピックが全ページ表示で開きます。

### ドロワーでエピックを開く {#open-epics-in-a-drawer}

{{< history >}}

- GitLab 17.4で`work_item_view_for_issues`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/464698)されました。デフォルトでは有効になっています。
- ドロワーと全ページ表示を切り替える機能がGitLab 18.2で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/536620)。
- GitLab 18.6で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/500367)になりました。機能フラグ`epics_list_drawer`は削除されました。

{{< /history >}}

エピックページまたはエピックボードからエピックを選択すると、ドロワーで開きます。これにより、エピックリストまたはボードのコンテキストを失うことなく、詳細を表示および編集できます。

ドロワーを使用する場合: 

- リストからエピックを選択して、ドロワーで開きます。
- ドロワーが画面の右側に表示されます。
- ドロワーでエピックを直接編集できます。
- ドロワーを閉じるには、閉じるアイコン（{{< icon name="close" >}}）を選択するか、**エスケープ**キーを押します。

#### 全ページ表示でエピックを開く {#open-an-epic-in-full-page-view}

全ページ表示でエピックを開くには: 

- 新しいタブでエピックを開きます。エピックのリストから、次のいずれかの操作を行います: 
  - エピックを右クリックして、新しいブラウザタブで開きます。
  - <kbd>Command</kbd>または<kbd>Control</kbd>を押しながら、エピックを選択します。
- エピックを選択し、ドロワーの左上隅で、**全ページ表示**（{{< icon name="maximize" >}}）を選択します。

#### ドロワーでエピックを開くかどうかを設定する {#set-preference-whether-to-open-epics-in-a-drawer}

エピックページでエピックをどのように開くかを構成するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。
1. 右上隅で、**オプションの表示**（{{< icon name="preferences" >}}）を選択します。
1. **サイドパネルにアイテムを開く**を切り替えます: 
   - **オン**: エピックはドロワーオーバーレイで開きます。
   - **オフ**: エピックが全ページ表示で開きます。

設定は保存され、すべてのセッションとデバイスで記憶されます。

### キャッシュされるエピック数 {#cached-epic-count}

サイドバーに表示されるオープンエピックの合計数は、1,000を超えるとキャッシュされます。キャッシュされた値は、千または百万の単位に丸められ、24時間ごとに更新されます。

## エピックのリストをフィルタリングする {#filter-the-list-of-epics}

{{< history >}}

- カスタムフィールドによるフィルタリングは、GitLab 17.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/525462)されました。

{{< /history >}}

エピックのリストは、次の項目でフィルターリングできます: 

- タイトルまたは説明（**検索範囲**を選択）
- 作成者名/ユーザー名
- 機密性
- グループ
- ヘルス
- ラベル
- マイルストーン
- リアクション絵文字
- 親
- 登録
- [エピック](../../../user/work_items/custom_fields.md)に対してカスタムフィールドが有効

フィルタリングするには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。
1. **結果を検索またはフィルタリング**フィールドを選択します。
1. ドロップダウンリストから範囲を選択するか、プレーンテキストを入力してエピックのタイトルまたは説明で検索します。
1. キーボードで<kbd>Enter</kbd>キーを押します。リストがフィルタリングされます。

### OR演算子でフィルタリングする {#filter-with-the-or-operator}

{{< history >}}

- ラベルと作成者のORフィルタリングは、GitLab 15.9で`or_issuable_queries`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/382969)されました。デフォルトでは無効になっています。
- GitLab 15.9の[GitLab.comとGitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104292)になりました。
- GitLab 17.0で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/296031)になりました。機能フラグ`or_issuable_queries`は削除されました。

{{< /history >}}

次の項目で[エピックのリストをフィルタリング](#filter-the-list-of-epics)するときに、OR演算子（**次のいずれか: `||`**）を使用できます:

- 作成者
- ラベル

`is one of`は、包含的ORを表します。たとえば、`Label is one of Deliverable`と`Label is one of UX`でフィルタリングすると、GitLabは`Deliverable`、`UX`、またはその両方のラベルが付いたエピックを表示します。

## エピックのリストをソートする {#sort-the-list-of-epics}

エピックリストは、次の順にソートすることができます: 

- 作成日
- 更新日
- クローズ日
- マイルストーンの期日
- 期限
- 人気度:
- タイトル
- 開始日
- ヘルス
- ブロック

各オプションには、順序を**昇順**と**降順**の間で切り替えることができるボタンがあります。ソートオプションと順序は保持され、[ロードマップ](../roadmap/_index.md)など、エピックを参照する場所で使用されます。

## アクティビティーの並べ替え順序を変更する {#change-activity-sort-order}

デフォルトの順序を逆にして、一番上に最新のアイテムが配置されたアクティビティーフィードを操作できます。設定はローカルストレージに保存され、表示するすべてのエピックとイシューに自動的に適用されます。

アクティビティーのソート順を変更するには、**古い順**ドロップダウンリストを選択し、一番古いアイテムから表示するのか、一番新しいアイテムから表示するのかを選択します。

## エピックを非公開にする {#make-an-epic-confidential}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

個人情報を含むアイテムで作業している場合は、エピックを非公開にすることができます。

{{< alert type="note" >}}

非公開のエピックには、[非公開のイシュー](../../project/issues/confidential_issues.md)と非公開の子エピックのみを含めることができます。ただし、マージリクエストは、公開プロジェクトで作成された場合は公開されます。非公開のマージリクエストの作成方法については、「[非公開のイシューのマージリクエスト](../../project/merge_requests/confidential.md)」を参照してください。

{{< /alert >}}

前提要件:

- エピックのグループに対してプランナーロール以上を持っている必要があります。

エピックを非公開にするには: 

- **When creating an epic**（エピックを作成する場合）: **非公開に設定**の横にあるチェックボックスをオンにします。
- **In an existing epic**（既存のエピック）: 右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。次に、**非公開に設定**を選択します。

`/confidential`[クイックアクション](../../project/quick_actions.md)を使用することもできます。

## エピックに割り当てられたイシューを管理する {#manage-issues-assigned-to-an-epic}

このセクションでは、エピックに関連して[イシュー](../../project/issues/_index.md)に対して実行できるすべての操作について説明します。

### エピックに割り当てられたイシューを表示する {#view-issues-assigned-to-an-epic}

**子アイテム**セクションでは、このエピックに割り当てられたエピック、イシュー、およびタスクを確認できます。子孫アイテムによって継承されるエピック、イシュー、タスクも表示できます。アクセスできるエピック、イシュー、タスクのみがリストに表示されます。

イシューがグループの子プロジェクトに含まれている場合は、エピックに割り当てられているイシューを常に表示できます。これは、プロジェクトの表示レベル設定は、親グループと同じにするか、親グループよりも制限を緩くする必要があるためです。

### エピック内のイシューの数とウェイトを表示する {#view-count-and-weight-of-issues-in-an-epic}

**子アイテム**セクションのヘッダーには、子孫のエピックとイシューの数、およびそれらの合計ウェイトが表示されます。タスクはこれらの数に含まれません。

オープンおよびクローズのエピックとイシューの数を確認するには: 

- セクションヘッダーまたは各エピック名の下で、合計数にカーソルを合わせます。

この数字は、表示する権限がないものも含め、エピックに関連付けられているすべての子イシューと子エピックを表しています。

### エピックの進捗状況を表示する {#view-epic-progress}

{{< history >}}

- GitLab 17.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/5163)されました。

{{< /history >}}

**子アイテム**セクションのヘッダーに、エピックの進捗率が表示されます。タスクはこの計算に含まれません。

子イシューの完了したウェイトと合計ウェイトを確認するには: 

- セクションヘッダーで、パーセンテージにカーソルを合わせます。

ウェイトと進捗状況は、表示する権限がないイシューを含め、エピックに関連付けられているすべてのイシューを表しています。

### ヘルスステータス {#health-status}

{{< details >}}

- プラン: Ultimate

{{< /details >}}

{{< history >}}

- GitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/9002)されました。

{{< /history >}}

エピックのヘルスステータスを使用して、プロジェクトの進捗状況をすばやく把握します。ヘルスステータスは、潜在的なイシューを事前に伝達および管理するのに役立ちます。

エピックのヘルスステータスは、エピックビュー、**子アイテム**セクション、**リンクされたアイテム**セクションで確認できます。

ヘルスステータスは次のように設定できます:

- 健全（緑）
- 要注意（黄）
- リスクあり（赤）

計画された作業のタイムリーなデリバリーを妨げるリスクに対処するために、エピックヘルスステータスのレビューを次の項目に組み込みます: 

- 毎日のスタンドアップミーティング
- プロジェクトの状態に関するレポート
- 週次ミーティング

#### エピックのヘルスステータスを変更する {#change-health-status-of-an-epic}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- グループのプランナーロール以上を持っている必要があります。

エピックのヘルスステータスを変更するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。
1. エピックを選択します。
1. 右側のサイドバーの**ヘルスステータス**セクションで、**編集**を選択します。
1. ドロップダウンリストから状態を選択します。

エピックのヘルスステータスが更新されます。

`/health_status`と`/clear_health_status`の[クイックアクション](../../project/quick_actions.md#issues-merge-requests-and-epics)を使用して、ヘルスステータスを設定およびクリアすることもできます。

### エピックにイシューを追加する {#add-an-issue-to-an-epic}

{{< history >}}

- 子イシューと子エピックの最大数が、GitLab 17.1で5,000に[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/452111)されました。

{{< /history >}}

既存のイシューをエピックに追加するか、エピックに自動的に追加される新しいイシューを作成します。

直接の子イシューと子エピックの最大数は5,000です。

#### エピックに既存のイシューを追加する {#add-an-existing-issue-to-an-epic}

[別のグループ階層](_index.md#child-issues-from-different-group-hierarchies)のプロジェクトのイシューを含め、既存のイシューをエピックに追加できます。新しく追加されたイシューは、**子アイテム**セクションのイシューリストの一番上に表示されます。

エピックにはイシューのリストが含まれており、イシューは最大で1つのエピックの子アイテムとして設定できます。すでにエピックにリンクされている新しいイシューを追加すると、そのイシューは現在の親から自動的にリンク解除されます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックに既存のイシューを追加するには: 

1. エピックのページで、**子アイテム**の下の**追加**を選択します。
1. **Existing issue**（既存のイシュー）を選択します。
1. 次のいずれかの方法を使用して、追加するイシューを指定します: 
   - イシューのリンクを貼り付けます。
   - イシューのタイトルの一部を入力して、一致する目的の項目を選択し、目的のイシューを検索します。別のグループ階層からのイシューは、検索結果に表示されません。そのようなイシューを追加するには、完全なURLを入力します。

   追加するイシューが複数ある場合は、<kbd>スペース</kbd>キーを押して、この手順を繰り返します。
1. **追加**を選択します。

#### エピックからイシューを作成する {#create-an-issue-from-an-epic}

エピックからイシューを作成すると、作業をより小さな部分に分割しながら、エピックのより広範なコンテキストに焦点を当て続けることができます。

エピックからの新しいイシューは、エピックのグループまたはその子孫サブグループの1つにあるプロジェクトでのみ作成できます。[エピックのグループと共有されているプロジェクト](../../project/members/sharing_projects_groups.md)に新しいイシューを作成するには、最初に[プロジェクトで直接イシューを作成](../../project/issues/create_issues.md#from-a-project)し、次に[既存のイシューをエピックに追加](#add-an-existing-issue-to-an-epic)します。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックからイシューを作成するには:

1. エピックのページで、**子アイテム**の下の**追加**を選択します。
1. **Add a new issue**（新しいイシューを作成）を選択します。
1. **タイトル**の下に、新しいイシューのタイトルを入力します。
1. **プロジェクト**ドロップダウンリストから、イシューを作成するプロジェクトを選択します。
1. **イシューの作成**を選択します。

新しいイシューがエピックに割り当てられます。

### エピックからイシューを削除する {#remove-an-issue-from-an-epic}

エピックの詳細ページで、エピックからイシューを削除できます。エピックからイシューを削除すると、このイシューはこのエピックとの関連付けが解除されます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックからイシューを削除するには: 

1. 削除するイシューの横にある**削除**（{{< icon name="close" >}}）を選択します。**Remove issue**（イシューを削除）警告が表示されます。
1. **削除**を選択します。

![エピックに割り当てられたイシューのリスト](img/issue_list_v15_11.png)

### エピックに割り当てられたイシューを並べ替える {#reorder-issues-assigned-to-an-epic}

新しいイシューは、**子アイテム**セクションのリストの一番上に表示されます。イシューのリストは、ドラッグして並べ替えることができます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

エピックに割り当てられたイシューを並べ替えるには: 

1. **子アイテム**セクションに移動します。
1. イシューを目的の順序にドラッグします。

### エピック間でイシューを移動する {#move-issues-between-epics}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

新しいイシューは、**子アイテム**タブのリストの一番上に表示されます。イシューはエピック間で移動できます。

前提要件:

- イシューのプロジェクトとエピックのグループに対して、ゲストロール以上を持っている必要があります。

イシューを別のエピックに移動するには: 

1. **子アイテム**セクションに移動します。
1. 表示されている階層で、イシューを目的の親エピックにドラッグします。

## マルチレベルの子エピック {#multi-level-child-epics}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループまたは親エピックのグループのサブグループに属する任意のエピックを追加できます。新しい子エピックは、**子アイテム**セクションのエピックリストの一番上に表示されます。

すでに親エピックにリンクされているエピックを追加すると、現在の親へのリンクは解除されます。

エピックには、合計7レベルまでのネストされた複数の子エピックを含めることができます。

### エピックに親エピックを追加する {#add-a-parent-epic-to-an-epic}

{{< history >}}

- GitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/11198)されました。

{{< /history >}}

エピックの階層を作成するには、既存のエピックに親エピックを追加します。これにより、複数のエピックにわたる関連作業を整理して追跡できます。

前提要件:

- 親エピックのグループまたは子エピックのグループのいずれかに対して、ゲストロール以上を持っている必要があります。

親エピックを追加するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **エピック**を選択します。
1. エピックを選択します。
1. 右側のサイドバーの**親**セクションで、**編集**を選択します。
1. 検索ボックスに、親エピックのタイトルの一部を入力します。同じグループ階層内のエピックのみを検索できます。
1. 検索結果から、親として追加するエピックを選択します。

親エピックが追加されます。

### 他のグループからの子エピック {#child-epics-from-other-groups}

親エピックのグループとは異なるグループに属する子エピックを追加します。

前提要件:

- 子エピックと親エピックの両方のグループに対して、ゲストロール以上を持っている必要があります。
- 子エピックと親エピックの両方のグループで、マルチレベルの子エピックを利用できる必要があります。

別のグループから子エピックを追加するには、[既存のエピックを追加する](#add-a-child-epic-to-an-epic)ときに、エピックのURLを貼り付けます。

### ロードマップで子エピックを表示する {#view-child-epics-on-a-roadmap}

エピックから、[ロードマップ](../roadmap/_index.md)でその子エピックと関連するマイルストーンを表示します。

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

親から子エピックを表示するには: 

- エピックで、**子アイテム**セクションの**Roadmap view**（ロードマップ表示）を選択します。

### エピックに子エピックを追加する {#add-a-child-epic-to-an-epic}

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

#### 新しいエピック {#new-epic}

新しいエピックを子エピックとして追加するには: 

1. エピックで、**子アイテム**セクションの**追加** > **Add a new epic**（新しいエピックを追加）を選択します。
1. ドロップダウンリストからグループを選択します。エピックのグループはデフォルトで選択されています。
1. 新しいエピックのタイトルを入力します。
1. **エピックを作成**を選択します。

#### 既存のエピック {#existing-epic}

既存のエピックを子エピックとして追加するには: 

1. エピックの**子アイテム**セクションで、**追加** > **Existing epic**（既存のエピック）を選択します。
1. 次のいずれかの方法で、追加するエピックを指定します: 
   - エピックのリンクを貼り付けます。
   - エピックのタイトルの一部を入力して、一致する目的の項目を選択し、目的のエピックを検索します。この検索は、同じグループ階層内のエピックにのみ利用できます。

   追加するエピックが複数ある場合は、<kbd>Space</kbd>キーを押してこの手順を繰り返します。
1. **追加**を選択します。

### エピック間で子エピックを移動する {#move-child-epics-between-epics}

新しい子エピックは、**子アイテム**セクションのリストの一番上に表示されます。子エピックはエピック間で移動できます。すでに親エピックにリンクされている新しいエピックを追加すると、現在の親へのリンクは解除されます。イシューと子エピックを混在させることはできません。

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

子エピックを別のエピックに移動するには: 

1. **子アイテム**セクションに移動します。
1. エピックを目的の親エピックにドラッグします。

### エピックに割り当てられた子エピックを並べ替える {#reorder-child-epics-assigned-to-an-epic}

新しい子エピックは、**子アイテム**セクションのリストの一番上に表示されます。子エピックのリストを並べ替えることができます。

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

エピックに割り当てられた子エピックを並べ替えるには: 

1. **子アイテム**セクションに移動します。
1. エピックを目的の順序にドラッグします。

### 親エピックから子エピックを削除する {#remove-a-child-epic-from-a-parent-epic}

前提要件:

- 親エピックのグループに対してゲストロール以上を持っている必要があります。

親エピックから子エピックを削除するには: 

1. 親エピックのエピックのリストで**削除**（{{< icon name="close" >}}）を選択します。**Remove epic**（エピックを削除）警告が表示されます。
1. **削除**を選択します。
