---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: プロジェクトのコードの作成、追跡、デリバリーを行います。
title: コード管理を始める
---

GitLabは、コードの作成からデリバリーまで、ソフトウェア開発ライフサイクル全体を支援するツールを提供します。

GitLabでのコードの作成と管理について詳しく説明します。このプロセスには、コードの作成、レビュー、バージョン管理によるコミット、時間の経過に伴う更新が含まれます。

このプロセスは、以下に示すより大きなワークフローの一部です。

![コードの管理プロセスが、GitLab DevOpsライフサイクルのCreateステージに含まれています。](img/get_started_code_workflow_v16_11.png)

## ステップ1: リポジトリを作成する {#step-1-create-a-repository}

プロジェクトは、他のユーザーとの共同作業、イシューの追跡、マージリクエストの管理、CI/CDパイプラインの自動化などを行うための一元化された場所です。

各プロジェクトにはリポジトリが含まれており、ソフトウェア開発作業に関連するコード、ドキュメント、その他のファイルを保存できます。リポジトリ内のファイルに加えられた変更は追跡されるため、履歴を確認できます。

リポジトリはソースコードのバージョン管理に重点を置いていますが、プロジェクトはソフトウェア開発ライフサイクル全体を包括的に管理できる環境を提供します。

詳細については、以下を参照してください。

- [リポジトリを作成する](../project/repository/_index.md#create-a-repository)

## ステップ2: コードを記述する {#step-2-write-your-code}

コードを記述する方法と場所については多くの選択肢があります。

GitLab UIを使用して、ブラウザーで直接開発できます。次の2つの方法があります。

- Webエディタと呼ばれるプレーンテキストエディタを使用して、単一のファイルを編集する。
- Web IDEと呼ばれる多機能のエディタを使用して、複数のファイルを編集する。

ローカルで作業したい場合は、Gitを使用してリポジトリをコンピューターにクローンし、お好みのIDEで開発します。その後、いずれかのGitLabエディタ拡張機能を使用することで、GitLabとの連携が容易になります。

最初の2つの方法を使用したくない場合は、リモート開発環境を起動し、クラウドで作業することも可能です。

さらに、個別のワークスペースを作成して開発環境を分割できます。ワークスペースは、複数のプロジェクトが相互に影響を及ぼさないようにするための独立した開発環境です。

詳細については、以下を参照してください。

- [UIからリポジトリ内にファイルを作成する](../project/repository/_index.md#add-a-file-from-the-ui)
- [Web IDEでファイルを開く](../project/web_ide/_index.md#from-a-file)
- [ワークスペースを使用してリモート開発環境を作成する](../workspace/_index.md)
- [利用可能なエディタ拡張機能](../../editor_extensions/_index.md)
- [コード提案を使用してコードをすばやく記述する](../project/repository/code_suggestions/_index.md)

## ステップ3: 変更を保存してGitLabにプッシュする {#step-3-save-changes-and-push-to-gitlab}

変更内容の準備ができたら、それらをGitLabにコミットし、チームメンバーと共有できるようにします。

変更をコミットするには、まずその内容をコピーします。

- コピー元はローカルコンピューター上の自分のブランチです。
- コピー先はリモートコンピューター上のGitLabの`default branch`です。

ブランチ間でファイルをコピーするには、マージリクエストを作成します。作成方法は、コードを作成した場所やツールによって異なります。基本的な考え方は、ソースブランチの内容を取得し、それをターゲットブランチに統合するよう提案するマージリクエストを作成することです。

詳細については、以下を参照してください。

- [Gitを使用してマージリクエストを作成する](../../tutorials/make_first_git_commit/_index.md)
- [ファイルを追加、編集、アップロードする際にUIを使用してマージリクエストを作成する](../project/merge_requests/creating_merge_requests.md)

## ステップ4: コードのレビューを受ける {#step-4-have-the-code-reviewed}

コードベースへの変更を提案するマージリクエストを作成したら、その提案のレビューを受けることができます。コードレビューは、コードの品質と一貫性を維持するのに役立ちます。また、チームメンバー間で知識を共有する機会にもなります。

マージリクエストには、提案された変更とマージ先のブランチとの差分が表示されます。

レビュアーは変更内容を確認し、特定のコード行にコメントを残すことができます。また、レビュアーは差分に対して直接変更を提案することもできます。

レビュアーは変更を承認したり、マージする前に追加の変更をリクエストしたりできます。GitLabはレビューステータスを追跡し、必要な承認が得られるまでマージを防ぎます。

組織によっては、特定の承認を必須とする、または特定のアクションを防止する保護ルールが設定されている場合があります。たとえば、変更するファイルに対してコードオーナーからの承認が必要な場合や、マージリクエストをマージする前に一定数の承認を得る必要がある場合などです。

詳細については、以下を参照してください。

- [マージリクエストのレビューをリクエストする](../project/merge_requests/reviews/_index.md#request-a-review)
- [マージリクエストに提案を追加する](../project/merge_requests/reviews/suggestions.md#create-suggestions)
- [マージリクエストの承認](../project/merge_requests/approvals/_index.md)
- [GitLabコードオーナー](../project/codeowners/_index.md)

## ステップ5: マージリクエストをマージする {#step-5-merge-the-merge-request}

変更をマージする前に、マージリクエストは通常、他のユーザーによる承認と、CI/CDパイプラインの成功が必要です。要件は組織によって異なりますが、一般的には次の点を確認する必要があります。

- コードの変更が組織のガイドラインに準拠している。
- コミットメッセージが明確で、関連するイシューにリンクされている。

保護されたブランチやその他のリポジトリ保護対策により、直接マージできなかったり、追加の手順が必要になったりする場合があります。変更をマージできない場合は、適用されている保護ルールについてチームに確認してください。

自分のブランチを作成した後、ターゲットブランチにマージする前に他のユーザーが同じファイルを編集した場合、マージコンフリクトが発生する可能性があります。マージする前に、すべてのコンフリクトを解決する必要があります。

詳細については、以下を参照してください。

- [マージコンフリクト](../project/merge_requests/conflicts.md)
- [マージ方法](../project/merge_requests/methods/_index.md)
- [リポジトリを保護する](../project/repository/protect.md)
