/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.CommonUtils;

public class SQLQueryValueFunctionExpression
extends SQLQueryValueExpression {
    @Nullable
    private final SQLQueryComplexName procName;
    @NotNull
    private final List<SQLQueryValueExpression> operands;
    @Nullable
    private DBSProcedure procedure = null;
    private boolean forRows;

    public SQLQueryValueFunctionExpression(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryComplexName procName, @NotNull List<SQLQueryValueExpression> operands, boolean forRows) {
        super(syntaxNode, (SQLQueryNodeModel[])operands.toArray(SQLQueryValueExpression[]::new));
        this.procName = procName;
        this.operands = operands;
        this.forRows = forRows;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.procName);
    }

    @Nullable
    public SQLQueryComplexName getProcName() {
        return this.procName;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.procName != null && this.procName.parts.getLast() != null ? this.procName.parts.getLast().getSymbol() : new SQLQuerySymbol("?");
    }

    @NotNull
    public List<SQLQueryValueExpression> getOperands() {
        return this.operands;
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        for (SQLQueryValueExpression expr : this.operands) {
            expr.resolveRowSources(context, statistics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        CandidateProcedure proc;
        SQLQuerySymbolOrigin origin;
        if (this.procName == null) {
            statistics.appendError(this.getSyntaxNode(), "Invalid function reference");
            return SQLQueryExprType.UNKNOWN;
        }
        SQLQuerySymbolOrigin sQLQuerySymbolOrigin = origin = this.forRows ? new SQLQuerySymbolOrigin.RowsSourceRef(context.getRowsSources()) : new SQLQuerySymbolOrigin.RowsDataRef(context);
        if (this.procName.invalidPartsCount > 0) {
            SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName, origin, SQLQuerySymbolOrigin.DbObjectFilterMode.FUNCTION, SQLQuerySymbolClass.ERROR);
            statistics.appendError(this.getSyntaxNode(), "Invalid function reference");
            return SQLQueryExprType.UNKNOWN;
        }
        if (context.getConnection().isDummy()) {
            this.procName.parts.forEach(p -> p.getSymbol().setSymbolClass(SQLQuerySymbolClass.FUNCTION));
            return SQLQueryExprType.UNKNOWN;
        }
        if (!statistics.validateFunctions()) {
            SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName, origin, SQLQuerySymbolOrigin.DbObjectFilterMode.FUNCTION, SQLQuerySymbolClass.FUNCTION);
            return SQLQueryExprType.UNKNOWN;
        }
        if (this.procName.parts.size() == 1) {
            SQLQuerySymbolEntry name = this.procName.parts.getFirst();
            if (context.getConnection().dialect.getFunctions().contains(name.getName())) {
                name.getSymbol().setSymbolClass(SQLQuerySymbolClass.FUNCTION);
                name.setOrigin(origin);
                return SQLQueryExprType.UNKNOWN;
            }
        }
        List<? extends DBSObject> candidates = context.getConnection().findRealObjects(statistics.getMonitor(), RelationalObjectType.TYPE_PROCEDURE, this.procName.stringParts);
        ArrayList<CandidateProcedure> procs = new ArrayList<CandidateProcedure>(candidates.size());
        try {
            for (DBSObject dBSObject : candidates) {
                DBSObject targetObj = SQLQueryConnectionContext.expandAliases(statistics.getMonitor(), dBSObject);
                if (!(targetObj instanceof DBSProcedure)) continue;
                DBSProcedure p2 = (DBSProcedure)targetObj;
                procs.add(SQLQueryValueFunctionExpression.prepareFunctionApplication(this, dBSObject, p2, statistics));
            }
        }
        catch (DBException ex) {
            statistics.appendError(this.procName.syntaxNode, "Failed to obtain function information", ex);
            return SQLQueryExprType.UNKNOWN;
        }
        if (procs.isEmpty()) {
            proc = null;
        } else if (procs.size() == 1) {
            proc = (CandidateProcedure)procs.getFirst();
        } else {
            CandidateProcedure candidateProcedure = procs.stream().filter(p -> CommonUtils.isEmpty(p.validationErrors)).findFirst().orElse(null);
            long totalOkMatches = procs.stream().filter(p -> CommonUtils.isEmpty(p.validationErrors)).count();
            proc = procs.stream().allMatch(CandidateProcedure::checked) ? (candidateProcedure != null && totalOkMatches == 1L ? candidateProcedure : null) : null;
            if (proc == null) {
                this.procName.parts.getLast().getSymbol().setSymbolClass(SQLQuerySymbolClass.FUNCTION);
                if (this.procName.parts.size() > 1) {
                    SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName.trimEnd(), origin, SQLQuerySymbolOrigin.DbObjectFilterMode.FUNCTION, SQLQuerySymbolClass.FUNCTION);
                }
                return SQLQueryExprType.UNKNOWN;
            }
        }
        DBSProcedure dBSProcedure = this.procedure = proc == null ? null : proc.procedure;
        if (this.procedure != null) {
            void var7_20;
            SQLQuerySemanticUtils.setNamePartsDefinition(context.getRowsSources(), this.procName, proc.referenceTarget, SQLQuerySymbolClass.FUNCTION, origin, SQLQuerySymbolOrigin.DbObjectFilterMode.FUNCTION);
            if (proc.validationErrors != null) {
                proc.validationErrors.forEach(Runnable::run);
            }
            Object var7_11 = null;
            try {
                void var7_14;
                if (proc.results != null) {
                    if (proc.results.size() == 1) {
                        SQLQueryExprType sQLQueryExprType = SQLQueryExprType.forTypedObject(statistics.getMonitor(), proc.results.getFirst().getParameterType(), SQLQuerySymbolClass.FUNCTION);
                    } else if (proc.results.size() > 1 && proc.results.getFirst().getParameterKind() == DBSProcedureParameterKind.TABLE) {
                        HashMap<String, SQLQueryExprType> fields = new HashMap<String, SQLQueryExprType>(proc.results.size());
                        for (DBSProcedureParameter ret : proc.results) {
                            SQLQueryExprType fieldType = SQLQueryExprType.forTypedObject(statistics.getMonitor(), ret.getParameterType(), SQLQuerySymbolClass.COMPOSITE_FIELD);
                            fields.put(ret.getName(), fieldType);
                        }
                        SQLQuerySymbolByDbObjectDefinition declarator = new SQLQuerySymbolByDbObjectDefinition((DBSObject)this.procedure, SQLQuerySymbolClass.FUNCTION);
                        SQLQueryExprType sQLQueryExprType = SQLQueryExprType.forSynthesizedArray(this.procName.getNameString() + ":resultTable", declarator, SQLQueryExprType.forSynthesizedComposite(this.procName.getNameString() + ":resultRow", this.procedure.getDataSource(), declarator, fields));
                    }
                }
                if (var7_14 == null && proc.returnType != null) {
                    SQLQueryExprType sQLQueryExprType = SQLQueryExprType.forTypedObject(statistics.getMonitor(), proc.returnType, SQLQuerySymbolClass.FUNCTION);
                }
            }
            catch (DBException e) {
                statistics.appendError(this.procName.syntaxNode, this.procName.getNameString() + " failed to obtain function info", e);
            }
            finally {
                if (var7_11 == null) {
                    SQLQueryExprType sQLQueryExprType = SQLQueryExprType.UNKNOWN;
                }
            }
            return var7_20;
        }
        SQLQuerySymbolClass sQLQuerySymbolClass = statistics.isTreatErrorsAsWarnings() ? SQLQuerySymbolClass.FUNCTION : SQLQuerySymbolClass.ERROR;
        SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.procName, origin, SQLQuerySymbolOrigin.DbObjectFilterMode.FUNCTION, sQLQuerySymbolClass);
        if (candidates.isEmpty()) {
            statistics.appendError(this.procName.syntaxNode, "Function " + this.procName.getNameString() + " not found");
        }
        return SQLQueryExprType.UNKNOWN;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueFunctionExpr(this, arg);
    }

    @NotNull
    private static CandidateProcedure prepareFunctionApplication(@NotNull SQLQueryValueFunctionExpression callExpr, @NotNull DBSObject referenceTarget, @NotNull DBSProcedure procedure, @NotNull SQLQueryRecognitionContext statistics) throws DBException {
        boolean checked;
        ArrayList<DBSProcedureParameter> results;
        ArrayList<DBSProcedureParameter> arguments;
        DBSTypedObject returnType = procedure.getReturnType(statistics.getMonitor());
        List<Runnable> errors = null;
        Collection params = procedure.getParameters(statistics.getMonitor());
        if (params != null) {
            arguments = new ArrayList<DBSProcedureParameter>(params.size());
            results = new ArrayList<DBSProcedureParameter>(params.size());
            for (DBSProcedureParameter param : params) {
                switch (param.getParameterKind()) {
                    case IN: 
                    case OUT: 
                    case INOUT: {
                        arguments.add(param);
                        break;
                    }
                    case RETURN: 
                    case RESULTSET: 
                    case TABLE: {
                        results.add(param);
                        break;
                    }
                }
            }
        } else {
            arguments = null;
            results = null;
        }
        if (arguments != null) {
            if (arguments.size() != callExpr.operands.size()) {
                errors = SQLQueryValueFunctionExpression.noteError(errors, callExpr.getSyntaxNode(), "Illegal amount of arguments: given " + callExpr.operands.size() + " while expected " + arguments.size(), statistics);
            }
            for (int i = 0; i < arguments.size() && i < callExpr.operands.size(); ++i) {
                boolean comparable;
                SQLQueryExprType srcType = callExpr.operands.get((int)i).type;
                DBSTypedObject tgtType = ((DBSProcedureParameter)arguments.get(i)).getParameterType();
                DBPDataKind src = srcType.getDataKind();
                DBPDataKind tgt = tgtType.getDataKind();
                boolean bl = comparable = src != DBPDataKind.UNKNOWN && src != DBPDataKind.ANY && tgt != DBPDataKind.UNKNOWN && tgt != DBPDataKind.ANY;
                if (!comparable || DBPDataKind.canConsume((DBPDataKind)src, (DBPDataKind)tgt)) continue;
                errors = SQLQueryValueFunctionExpression.noteError(errors, callExpr.operands.get(i).getSyntaxNode(), "Inconsistent parameter type: expected " + tgtType.getFullTypeName() + " while given " + srcType.getDisplayName(), statistics);
            }
            checked = true;
        } else {
            checked = false;
        }
        return new CandidateProcedure(referenceTarget, procedure, arguments, results, returnType, checked, errors);
    }

    @NotNull
    private static List<Runnable> noteError(@Nullable List<Runnable> validationErrors, @NotNull STMTreeNode syntaxNode, @NotNull String message, @NotNull SQLQueryRecognitionContext statistics) {
        if (validationErrors == null) {
            validationErrors = new ArrayList<Runnable>();
        }
        validationErrors.add(() -> statistics.appendError(syntaxNode, message));
        return validationErrors;
    }

    private record CandidateProcedure(@NotNull DBSObject referenceTarget, @NotNull DBSProcedure procedure, @Nullable List<DBSProcedureParameter> arguments, @Nullable List<DBSProcedureParameter> results, @Nullable DBSTypedObject returnType, boolean checked, @Nullable List<Runnable> validationErrors) {
    }
}

