/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;

public class StreamDataImporterColumnInfo
extends AbstractAttribute
implements DBSEntityAttribute {
    private final StreamEntityMapping entityMapping;
    private DBPDataKind dataKind;
    private boolean mappingMetadataPresent;

    public StreamDataImporterColumnInfo(StreamEntityMapping entity, int columnIndex, @NotNull String columnName, @NotNull String typeName, int maxLength, DBPDataKind dataKind) {
        super(columnName, typeName, -1, columnIndex, (long)maxLength, null, null, false, false);
        this.entityMapping = entity;
        this.dataKind = dataKind;
    }

    public void updateMaxLength(@Nullable DBPDataSource dataSource, long maxLengthFromData) {
        long maxLength = this.getMaxLength();
        DBPPreferenceStore globalPreferenceStore = DTActivator.getDefault().getPreferences();
        if (dataSource != null) {
            DBPPreferenceStore dataSourcePreferenceStore = dataSource.getContainer().getPreferenceStore();
            int maxTypeLengthFromPref = dataSourcePreferenceStore.getInt("maxTypeLengthMapping");
            if (dataSourcePreferenceStore.contains("maxTypeLengthMapping") && maxLength > (long)maxTypeLengthFromPref) {
                this.setMaxLength(maxTypeLengthFromPref);
                return;
            }
        }
        if (globalPreferenceStore.contains("maxTypeLengthMapping") && maxLength > (long)globalPreferenceStore.getInt("maxTypeLengthMapping")) {
            this.setMaxLength(globalPreferenceStore.getInt("maxTypeLengthMapping"));
        } else if (maxLength < maxLengthFromData) {
            this.setMaxLength(StreamDataImporterColumnInfo.roundToNextPowerOf2(maxLengthFromData));
        }
    }

    public void updateType(@NotNull DBPDataKind newKind, @NotNull String newName) {
        if (newKind == this.getDataKind() && newName.equals(this.getTypeName())) {
            return;
        }
        DBPDataKind curKind = this.getDataKind();
        int curC = curKind.getCommonality();
        int newC = newKind.getCommonality();
        if (newC > curC || newC == curC && StreamDataImporterColumnInfo.isWiderNumeric(newKind, newName, this.getTypeName())) {
            this.setDataKind(newKind);
            this.setTypeName(newName);
        }
    }

    private static boolean isWiderNumeric(@NotNull DBPDataKind kind, @NotNull String newName, @NotNull String curName) {
        return kind == DBPDataKind.NUMERIC && StreamDataImporterColumnInfo.numericRank(newName) > StreamDataImporterColumnInfo.numericRank(curName);
    }

    private static int numericRank(@NotNull String typeName) {
        return switch (typeName) {
            case "INTEGER" -> 1;
            case "BIGINT" -> 2;
            case "REAL" -> 3;
            default -> 0;
        };
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @NotNull
    public StreamEntityMapping getParentObject() {
        return this.entityMapping;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.entityMapping.getDataSource();
    }

    public void setDataKind(DBPDataKind dataKind) {
        this.dataKind = dataKind;
    }

    public void setTypeName(@NotNull String typeName) {
        this.typeName = typeName;
    }

    public boolean isMappingMetadataPresent() {
        return this.mappingMetadataPresent;
    }

    public void setMappingMetadataPresent(boolean mappingMetadataPresent) {
        this.mappingMetadataPresent = mappingMetadataPresent;
    }

    private static long roundToNextPowerOf2(long value) {
        int result = 1;
        while ((long)result < value) {
            result <<= 1;
        }
        return result;
    }
}

