/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPSettingsSection;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsExecutor;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.simple.CompareReport;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportRenderer;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareObjectsPageOutput;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareObjectsPageSettings;
import org.jkiss.dbeaver.tools.compare.simple.ui.internal.CompareUIMessages;
import org.jkiss.dbeaver.ui.DialogSettingsDelegate;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class CompareObjectsWizard
extends Wizard
implements IExportWizard {
    private static final Log log = Log.getLog(CompareObjectsWizard.class);
    private static final String RS_COMPARE_WIZARD_DIALOG_SETTINGS = "CompareWizard";
    private final CompareObjectsSettings settings;

    public CompareObjectsWizard(List<DBNDatabaseNode> nodes) {
        this.settings = new CompareObjectsSettings(nodes);
        this.settings.setOutputFolder(DialogUtils.getCurDialogFolder());
        IDialogSettings section = UIUtils.getDialogSettings((String)RS_COMPARE_WIZARD_DIALOG_SETTINGS);
        this.setDialogSettings(section);
        this.settings.loadFrom((DBPSettingsSection)new DialogSettingsDelegate(section));
    }

    public void dispose() {
        super.dispose();
    }

    public CompareObjectsSettings getSettings() {
        return this.settings;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new CompareObjectsPageSettings());
        this.addPage((IWizardPage)new CompareObjectsPageOutput());
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle(CompareUIMessages.compare_objects_wizard_title);
        this.setNeedsProgressMonitor(true);
    }

    private void showError(String error) {
        if (CommonUtils.isNotEmpty((String)error)) {
            DBWorkbench.getPlatformUI().showError(CompareUIMessages.compare_objects_wizard_error_title, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        this.getSettings().saveTo((DBPSettingsSection)new DialogSettingsDelegate(this.getDialogSettings()));
        this.showError(null);
        CompareObjectsExecutor executor = new CompareObjectsExecutor(this.settings);
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                try {
                    CompareReport report = this.generateReport(monitor, executor);
                    this.renderReport(monitor, report);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
            UIUtils.showMessageBox((Shell)this.getShell(), (String)CompareUIMessages.compare_objects_wizard_finish_report_title, (String)CompareUIMessages.compare_objects_wizard_finish_report_info, (int)2);
        }
        catch (InvocationTargetException e) {
            if (executor.getInitializeError() != null) {
                this.showError(executor.getInitializeError().getMessage());
            } else {
                log.error((Object)e.getTargetException());
                this.showError(e.getTargetException().getMessage());
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            this.showError("Compare interrupted");
            boolean bl = false;
            return bl;
        }
        finally {
            executor.dispose();
        }
        return true;
    }

    private CompareReport generateReport(DBRProgressMonitor monitor, CompareObjectsExecutor executor) throws DBException, InterruptedException {
        monitor.beginTask("Compare objects", 1000);
        CompareReport report = executor.compareObjects(monitor, this.getSettings().getNodes());
        monitor.done();
        return report;
    }

    private void renderReport(DBRProgressMonitor monitor, CompareReport report) {
        try {
            Path reportFile;
            if (Objects.requireNonNull(this.settings.getOutputType()) == CompareObjectsSettings.OutputType.BROWSER) {
                reportFile = Files.createTempFile(DBWorkbench.getPlatform().getTempFolder(monitor, "compare-report"), "compare", ".html", new FileAttribute[0]);
            } else {
                StringBuilder fileName = new StringBuilder("compare");
                if (report.getNodes().size() <= 3) {
                    for (DBNDatabaseNode node : report.getNodes()) {
                        fileName.append("-").append(CommonUtils.escapeIdentifier((String)node.getName()));
                    }
                    fileName.append("-report.html");
                } else {
                    fileName.append("-report").append("-").append(RuntimeUtils.getCurrentTimeStamp()).append(".html");
                }
                Path parentFolder = Path.of(this.settings.getOutputFolder(), new String[0]);
                if (!Files.exists(parentFolder, new LinkOption[0])) {
                    Files.createDirectories(parentFolder, new FileAttribute[0]);
                }
                reportFile = parentFolder.resolve(fileName.toString());
            }
            try (OutputStream outputStream = Files.newOutputStream(reportFile, new OpenOption[0]);){
                monitor.beginTask("Render report", report.getReportLines().size());
                CompareReportRenderer reportRenderer = new CompareReportRenderer();
                reportRenderer.renderReport(monitor, report, this.getSettings(), outputStream);
                monitor.done();
            }
            if (this.settings.getOutputType() == CompareObjectsSettings.OutputType.BROWSER) {
                ShellUtils.launchProgram((String)reportFile.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            log.error((Object)e);
        }
    }
}

