%%
%% This is file `fhjbook.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% fhjbook.dtx  (with options: `class')
%% 
%% Copyright 2025 Michael E. Hammer
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Michael E. Hammer.
%% 
%% This file is part of the "fhj-script bundle" and all files in that
%% bundle must be distributed together.
%% 
\NeedsTeXFormat{LaTeX2e}[2023-11-01]
\ProvidesClass{fhjbook}
    [2026-02-25 v4.2c A class for formatting books/thesis in the FHJ style]
\newcommand{\@ClassName}{fhjbook}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{scrbook}}
\ProcessOptions\relax
\LoadClass[a4paper,DIV=14,BCOR=10mm]{scrbook}
\pagestyle{headings}
\RequirePackage{fhjcommon}
\PassOptionsToPackage{hidelinks}{hyperref}
\RequirePackage{hyperref}
\RequirePackage{array}
\RequirePackage{supertabular}
\RequirePackage{xstring}
\renewcommand*{\title}[1]{\renewcommand*{\@title}{{#1}}}
\newcommand{\check@title}{%
  \@ifundefined{@author}{
    \ClassWarningNoLine{fhjbook}{Author not defined}\author{first SECOND}
  }{}
  \@ifundefined{@title}{
    \ClassWarningNoLine{fhjbook}{Title not defined}\title{Title}
  }{}
  \@ifundefined{@supervisor}{
    \ClassWarningNoLine{fhjbook}{Supervisor not defined}\supervisor{Supervisor}{m}
  }{}
}
\newcommand{\check@abstract}{%
  \@ifundefined{@abstractDE}{
    \ClassWarningNoLine{fhjbook}{German ``Kurzfassung'' not defined!}\FHJAbstractDE{Eine Beispielkurzfassung...}{kw1,kw2}
  }{}
  \@ifundefined{@abstractEN}{
    \ClassWarningNoLine{fhjbook}{English abstract not defined!}\def\@abstractDE{An example abstract...}{kw1,kw2}
  }{}
}
\newif\ifsubtitlepresent\subtitlepresentfalse
\renewcommand{\subtitle}[1]
{\subtitlepresenttrue
  \def\thesissubtitle{#1}}

\newif\ifauthormale\authormalefalse
\newif\ifauthorfemale\authorfemalefalse
\newcommand{\authorinfo}[3]{
  \if#1m \authormaletrue \fi
  \if#1f \authorfemaletrue \fi
  \def\personenkennzahl{#2}
  \def\jahrgang{#3}
}

\newif\ifsupervisormale\supervisormalefalse
\newif\ifsupervisorfemale\supervisorfemalefalse
\newcommand{\supervisor}[2]{
  \def\@supervisor{#1}
  \if#2m \supervisormaletrue \fi
  \if#2f \supervisorfemaletrue \fi
}

\newif\ifcosupervisorpresent\cosupervisorpresentfalse
\newif\ifcosupervisormale\cosupervisormalefalse
\newif\ifcosupervisorfemale\cosupervisorfemalefalse
\newcommand{\cosupervisor}[2]{
  \cosupervisorpresenttrue
  \def\thesiscosupervisor{#1}
  \if#2m \cosupervisormaletrue \fi
  \if#2f \cosupervisorfemaletrue \fi
}

\newcommand{\FHJLocation}[1]{
  \newcommand{\@location}{#1}
}

\newcommand{\FHJMakeTitlePage}{%
\check@title%
\thispagestyle{empty}%
\begin{center}
%%  \IfStrEqCase{\FHJProgramShort}{
%%  {DAT}{%
%%    \includegraphics[width=70mm]{fhjInformaticsLogo.img.pdf}
%%  }{IMS}{%
%%    \includegraphics[width=70mm]{fhjInformaticsLogo.img.pdf}
%%  }
\iflanguage{ngerman}{\includegraphics[width=70mm]{fhjInformaticsLogo.de.img.pdf}}{}
\iflanguage{english}{\includegraphics[width=70mm]{fhjInformaticsLogo.en.img.pdf}}{}
\\[10mm]

\iflanguage{ngerman}{\textbf{MASTERARBEIT}}{}
\iflanguage{english}{\textbf{MASTER'S THESIS}}{}
\\[10mm]

\begin{minipage}{\textwidth}\begin{center}
  \fontsize{16}{20}\selectfont
  \textbf{\@title}
\end{center}\end{minipage}\\[5mm]

\ifsubtitlepresent
  {\large\thesissubtitle}\\[10mm]
\else
  \vspace*{15mm}
\fi

\iflanguage{ngerman}{
  {\footnotesize
  Eingereicht bei
  }\\[2mm]
  \FHJ\\
  Masterstudiengang\\
  ``\FHJProgramLong''
}{}
\iflanguage{english}{
  { \footnotesize
  Submitted at
  }\\[2mm]
  \FHJ\\
  Master's Degree Programme\\
  ``\FHJProgramLong''
}{}
\vspace*{10mm}

{ \footnotesize
\iflanguage{ngerman}{\ifauthormale Autor \else \ifauthorfemale Autorin \else Autor:in \fi \fi}{}
\iflanguage{english}{Author}{}\\[2mm]
}
\@author\\
\personenkennzahl\\
\iflanguage{english}{Cohort}{}\iflanguage{ngerman}{Jahrgang}{} \FHJProgramShort\ \jahrgang\\[10mm]

{\footnotesize
\iflanguage{ngerman}{\ifsupervisormale Betreuer \else \ifsupervisorfemale Betreuerin \else Betreuer:in \fi \fi}{}
\iflanguage{english}{Supervisor}{}\\[2mm]
}
\@supervisor\\[10mm]

\ifcosupervisorpresent
  {\footnotesize
  \iflanguage{ngerman}{\ifcosupervisormale Zweiter Betreuer \else \ifcosupervisorfemale Zweite Betreuerin \else Zweite:r Betreuer:in \fi \fi}{}
  \iflanguage{english}{Second Supervisor}{}\\[2mm]
  }
  \thesiscosupervisor
\fi

\end{center}

\vfill

\@location, \@date \hfill
\iflanguage{ngerman}{Unterschrift}{}
\iflanguage{english}{Signature}{}
\par\vspace*{1cm}
}

\newcommand{\FHJAbstractDE}[2]{%
  \newcommand{\@abstractDE}{#1}
  \newcommand*{\@keywordsDE}{#2}
}

\newcommand{\FHJAbstractEN}[2]{%
  \newcommand{\@abstractEN}{#1}
  \newcommand*{\@keywordsEN}{#2}
}

\newcommand*{\@lastkeyword}{}%
\newcommand*{\@kwseparator}{\space$\vert$\space}%
\newcommand{\@printkeyword}[1]{%
  \expandafter\ifblank\expandafter{\@lastkeyword}{}%
    {\@kwseparator}%
  {#1}%
  \renewcommand*{\@lastkeyword}{#1}%
}

\newcommand{\@printkeywords}[2]{%
  \renewcommand*{\@lastkeyword}{}%
  \IfStrEq{#2}{de}{\textit{Schlüsselwörter: }}{}%
  \IfStrEq{#2}{en}{\textit{Keywords: }}{}%
  \expandafter\forcsvlist\expandafter\@printkeyword\expandafter{#1}%
}

\newcommand{\FHJMakeAbstract}{%
\check@abstract
\cleardoublepage
\begingroup % to make sure we change parindent only in this group
  \setlength{\parindent}{0pt}
  \textbf{\Large Kurzfassung:}\\[5mm]
  \@abstractDE
  \vfill
  \@printkeywords{\@keywordsDE}{de}
  \clearpage
  \textbf{\Large Abstract:}\\[5mm]
  \@abstractEN
  \vfill
  \@printkeywords{\@keywordsEN}{en}
\endgroup
\cleardoublepage
}

%% Compile all title pages together
\newcommand{\FHJThesisFrontMatter}{%
\FHJMakeTitlePage%
\FHJMakeDeclaration%
\FHJMakeAbstract%
}
\endinput
%%
%% End of file `fhjbook.cls'.
