/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;

public class AlterShareGroupOffsetsResult {
    private final KafkaFuture<Map<TopicPartition, ApiException>> future;

    AlterShareGroupOffsetsResult(KafkaFuture<Map<TopicPartition, ApiException>> future) {
        this.future = future;
    }

    public KafkaFuture<Void> partitionResult(TopicPartition partition) {
        KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else if (!topicPartitions.containsKey(partition)) {
                result.completeExceptionally(new IllegalArgumentException("Alter offset for partition \"" + String.valueOf(partition) + "\" was not attempted"));
            } else {
                ApiException exception = (ApiException)topicPartitions.get(partition);
                if (exception == null) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(exception);
                }
            }
        });
        return result;
    }

    public KafkaFuture<Void> all() {
        return this.future.thenApply(topicPartitionErrorsMap -> {
            List partitionsFailed = topicPartitionErrorsMap.entrySet().stream().filter(e -> e.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toList());
            for (ApiException exception : topicPartitionErrorsMap.values()) {
                if (exception == null) continue;
                throw Errors.forException(exception).exception("Failed altering group offsets for the following partitions: " + String.valueOf(partitionsFailed));
            }
            return null;
        });
    }
}

