/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.builders;

import java.util.Map;
import java.util.Optional;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.AutoTopicCreationManager;
import kafka.server.FetchManager;
import kafka.server.ForwardingManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.share.SharePartitionManager;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.metadata.ConfigRepository;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.security.DelegationTokenManager;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.ClientMetricsManager;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class KafkaApisBuilder {
    private RequestChannel requestChannel = null;
    private ForwardingManager forwardingManager = null;
    private ReplicaManager replicaManager = null;
    private GroupCoordinator groupCoordinator = null;
    private TransactionCoordinator txnCoordinator = null;
    private AutoTopicCreationManager autoTopicCreationManager = null;
    private int brokerId = 0;
    private KafkaConfig config = null;
    private ConfigRepository configRepository = null;
    private MetadataCache metadataCache = null;
    private Metrics metrics = null;
    private Optional<Plugin<Authorizer>> authorizerPlugin = Optional.empty();
    private QuotaFactory.QuotaManagers quotas = null;
    private FetchManager fetchManager = null;
    private SharePartitionManager sharePartitionManager = null;
    private BrokerTopicStats brokerTopicStats = null;
    private String clusterId = "clusterId";
    private Time time = Time.SYSTEM;
    private DelegationTokenManager tokenManager = null;
    private ApiVersionManager apiVersionManager = null;
    private ClientMetricsManager clientMetricsManager = null;
    private ShareCoordinator shareCoordinator = null;
    private GroupConfigManager groupConfigManager = null;

    public KafkaApisBuilder setRequestChannel(RequestChannel requestChannel) {
        this.requestChannel = requestChannel;
        return this;
    }

    public KafkaApisBuilder setForwardingManager(ForwardingManager forwardingManager) {
        this.forwardingManager = forwardingManager;
        return this;
    }

    public KafkaApisBuilder setReplicaManager(ReplicaManager replicaManager) {
        this.replicaManager = replicaManager;
        return this;
    }

    public KafkaApisBuilder setGroupCoordinator(GroupCoordinator groupCoordinator) {
        this.groupCoordinator = groupCoordinator;
        return this;
    }

    public KafkaApisBuilder setTxnCoordinator(TransactionCoordinator txnCoordinator) {
        this.txnCoordinator = txnCoordinator;
        return this;
    }

    public KafkaApisBuilder setShareCoordinator(ShareCoordinator shareCoordinator) {
        this.shareCoordinator = shareCoordinator;
        return this;
    }

    public KafkaApisBuilder setAutoTopicCreationManager(AutoTopicCreationManager autoTopicCreationManager) {
        this.autoTopicCreationManager = autoTopicCreationManager;
        return this;
    }

    public KafkaApisBuilder setBrokerId(int brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    public KafkaApisBuilder setConfig(KafkaConfig config) {
        this.config = config;
        return this;
    }

    public KafkaApisBuilder setConfigRepository(ConfigRepository configRepository) {
        this.configRepository = configRepository;
        return this;
    }

    public KafkaApisBuilder setMetadataCache(MetadataCache metadataCache) {
        this.metadataCache = metadataCache;
        return this;
    }

    public KafkaApisBuilder setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public KafkaApisBuilder setAuthorizerPlugin(Optional<Plugin<Authorizer>> authorizerPlugin) {
        this.authorizerPlugin = authorizerPlugin;
        return this;
    }

    public KafkaApisBuilder setQuotas(QuotaFactory.QuotaManagers quotas) {
        this.quotas = quotas;
        return this;
    }

    public KafkaApisBuilder setFetchManager(FetchManager fetchManager) {
        this.fetchManager = fetchManager;
        return this;
    }

    public KafkaApisBuilder setSharePartitionManager(SharePartitionManager sharePartitionManager) {
        this.sharePartitionManager = sharePartitionManager;
        return this;
    }

    public KafkaApisBuilder setBrokerTopicStats(BrokerTopicStats brokerTopicStats) {
        this.brokerTopicStats = brokerTopicStats;
        return this;
    }

    public KafkaApisBuilder setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public KafkaApisBuilder setTime(Time time) {
        this.time = time;
        return this;
    }

    public KafkaApisBuilder setTokenManager(DelegationTokenManager tokenManager) {
        this.tokenManager = tokenManager;
        return this;
    }

    public KafkaApisBuilder setApiVersionManager(ApiVersionManager apiVersionManager) {
        this.apiVersionManager = apiVersionManager;
        return this;
    }

    public KafkaApisBuilder setClientMetricsManager(ClientMetricsManager clientMetricsManager) {
        this.clientMetricsManager = clientMetricsManager;
        return this;
    }

    public KafkaApisBuilder setGroupConfigManager(GroupConfigManager groupConfigManager) {
        this.groupConfigManager = groupConfigManager;
        return this;
    }

    public KafkaApis build() {
        if (this.requestChannel == null) {
            throw new RuntimeException("you must set requestChannel");
        }
        if (this.forwardingManager == null) {
            throw new RuntimeException("you must set forwardingManager");
        }
        if (this.replicaManager == null) {
            throw new RuntimeException("You must set replicaManager");
        }
        if (this.groupCoordinator == null) {
            throw new RuntimeException("You must set groupCoordinator");
        }
        if (this.txnCoordinator == null) {
            throw new RuntimeException("You must set txnCoordinator");
        }
        if (this.shareCoordinator == null) {
            throw new RuntimeException("You must set shareCoordinator");
        }
        if (this.autoTopicCreationManager == null) {
            throw new RuntimeException("You must set autoTopicCreationManager");
        }
        if (this.config == null) {
            this.config = new KafkaConfig(Map.of());
        }
        if (this.configRepository == null) {
            throw new RuntimeException("You must set configRepository");
        }
        if (this.metadataCache == null) {
            throw new RuntimeException("You must set metadataCache");
        }
        if (this.metrics == null) {
            throw new RuntimeException("You must set metrics");
        }
        if (this.quotas == null) {
            throw new RuntimeException("You must set quotas");
        }
        if (this.fetchManager == null) {
            throw new RuntimeException("You must set fetchManager");
        }
        if (this.sharePartitionManager == null) {
            throw new RuntimeException("You must set sharePartitionManager");
        }
        if (this.clientMetricsManager == null) {
            throw new RuntimeException("You must set clientMetricsManager");
        }
        if (this.brokerTopicStats == null) {
            this.brokerTopicStats = new BrokerTopicStats(this.config.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        }
        if (this.apiVersionManager == null) {
            throw new RuntimeException("You must set apiVersionManager");
        }
        if (this.groupConfigManager == null) {
            throw new RuntimeException("You must set groupConfigManager");
        }
        return new KafkaApis(this.requestChannel, this.forwardingManager, this.replicaManager, this.groupCoordinator, this.txnCoordinator, this.shareCoordinator, this.autoTopicCreationManager, this.brokerId, this.config, this.configRepository, this.metadataCache, this.metrics, (Option<Plugin<Authorizer>>)OptionConverters.toScala(this.authorizerPlugin), this.quotas, this.fetchManager, this.sharePartitionManager, this.brokerTopicStats, this.clusterId, this.time, this.tokenManager, this.apiVersionManager, this.clientMetricsManager, this.groupConfigManager);
    }
}

