/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataValue;

public class StreamsGroupMetadataValueJsonConverter {
    public static StreamsGroupMetadataValue read(JsonNode _node, short _version) {
        StreamsGroupMetadataValue _object = new StreamsGroupMetadataValue();
        JsonNode _epochNode = _node.get("epoch");
        if (_epochNode == null) {
            throw new RuntimeException("StreamsGroupMetadataValue: unable to locate field 'epoch', which is mandatory in version " + _version);
        }
        _object.epoch = MessageUtil.jsonNodeToInt((JsonNode)_epochNode, (String)"StreamsGroupMetadataValue");
        JsonNode _metadataHashNode = _node.get("metadataHash");
        if (_metadataHashNode == null) {
            throw new RuntimeException("StreamsGroupMetadataValue: unable to locate field 'metadataHash', which is mandatory in version " + _version);
        }
        _object.metadataHash = MessageUtil.jsonNodeToLong((JsonNode)_metadataHashNode, (String)"StreamsGroupMetadataValue");
        JsonNode _validatedTopologyEpochNode = _node.get("validatedTopologyEpoch");
        _object.validatedTopologyEpoch = _validatedTopologyEpochNode == null ? -1 : MessageUtil.jsonNodeToInt((JsonNode)_validatedTopologyEpochNode, (String)"StreamsGroupMetadataValue");
        JsonNode _lastAssignmentConfigsNode = _node.get("lastAssignmentConfigs");
        if (_lastAssignmentConfigsNode == null) {
            _object.lastAssignmentConfigs = new ArrayList<StreamsGroupMetadataValue.LastAssignmentConfig>(0);
        } else if (_lastAssignmentConfigsNode.isNull()) {
            _object.lastAssignmentConfigs = null;
        } else {
            if (!_lastAssignmentConfigsNode.isArray()) {
                throw new RuntimeException("StreamsGroupMetadataValue expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<StreamsGroupMetadataValue.LastAssignmentConfig> _collection = new ArrayList<StreamsGroupMetadataValue.LastAssignmentConfig>(_lastAssignmentConfigsNode.size());
            _object.lastAssignmentConfigs = _collection;
            for (JsonNode _element : _lastAssignmentConfigsNode) {
                _collection.add(LastAssignmentConfigJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(StreamsGroupMetadataValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("epoch", (JsonNode)new IntNode(_object.epoch));
        _node.set("metadataHash", (JsonNode)new LongNode(_object.metadataHash));
        if (_object.validatedTopologyEpoch != -1) {
            _node.set("validatedTopologyEpoch", (JsonNode)new IntNode(_object.validatedTopologyEpoch));
        }
        if (_object.lastAssignmentConfigs == null || !_object.lastAssignmentConfigs.isEmpty()) {
            if (_object.lastAssignmentConfigs == null) {
                _node.set("lastAssignmentConfigs", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _lastAssignmentConfigsArray = new ArrayNode(JsonNodeFactory.instance);
                for (StreamsGroupMetadataValue.LastAssignmentConfig _element : _object.lastAssignmentConfigs) {
                    _lastAssignmentConfigsArray.add(LastAssignmentConfigJsonConverter.write(_element, _version, _serializeRecords));
                }
                _node.set("lastAssignmentConfigs", (JsonNode)_lastAssignmentConfigsArray);
            }
        }
        return _node;
    }

    public static JsonNode write(StreamsGroupMetadataValue _object, short _version) {
        return StreamsGroupMetadataValueJsonConverter.write(_object, _version, true);
    }

    public static class LastAssignmentConfigJsonConverter {
        public static StreamsGroupMetadataValue.LastAssignmentConfig read(JsonNode _node, short _version) {
            StreamsGroupMetadataValue.LastAssignmentConfig _object = new StreamsGroupMetadataValue.LastAssignmentConfig();
            JsonNode _keyNode = _node.get("key");
            if (_keyNode == null) {
                throw new RuntimeException("LastAssignmentConfig: unable to locate field 'key', which is mandatory in version " + _version);
            }
            if (!_keyNode.isTextual()) {
                throw new RuntimeException("LastAssignmentConfig expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.key = _keyNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("LastAssignmentConfig: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (!_valueNode.isTextual()) {
                throw new RuntimeException("LastAssignmentConfig expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.value = _valueNode.asText();
            return _object;
        }

        public static JsonNode write(StreamsGroupMetadataValue.LastAssignmentConfig _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("key", (JsonNode)new TextNode(_object.key));
            _node.set("value", (JsonNode)new TextNode(_object.value));
            return _node;
        }

        public static JsonNode write(StreamsGroupMetadataValue.LastAssignmentConfig _object, short _version) {
            return LastAssignmentConfigJsonConverter.write(_object, _version, true);
        }
    }
}

