!===============================================================================
! Copyright (C) 2022 Intel Corporation
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

#include "mkl_omp_offload.f90"

program cgels_batch_strided_example

#ifdef MKL_ILP64
    use onemkl_lapack_omp_offload_ilp64
#else
    use onemkl_lapack_omp_offload_lp64
#endif

#define s(x) (x)
#define c(x) (0.0, x)

    integer, parameter :: m = 5, n = 5, nrhs = 1, lda = m, stride_a = n*lda, ldb = m, stride_b = nrhs*ldb, batch_size = 2
    integer i, j, num_errors

    complex*8 :: A(stride_a*batch_size) = (/ &
        c( 1.0 ), c(  0.0 ), c(  0.0 ), c(  0.0 ), c(  0.0 ), &
        c( 1.0 ), c(  0.2 ), c( -0.4 ), c( -0.4 ), c( -0.8 ), &
        c( 1.0 ), c(  0.6 ), c( -0.2 ), c(  0.4 ), c( -1.2 ), &
        c( 1.0 ), c(  1.0 ), c( -1.0 ), c(  0.6 ), c( -0.8 ), &
        c( 1.0 ), c(  1.8 ), c( -0.6 ), c(  0.2 ), c( -0.6 )  &
                                                            , &
        c( 0.2 ), c( -0.4 ), c( -0.4 ), c( -0.8 ), c(  0.0 ), &
        c( 0.4 ), c(  0.2 ), c(  0.8 ), c( -0.4 ), c(  0.0 ), &
        c( 0.4 ), c( -0.8 ), c(  0.2 ), c(  0.4 ), c(  0.0 ), &
        c( 0.8 ), c(  0.4 ), c( -0.4 ), c(  0.2 ), c(  0.0 ), &
        c( 0.0 ), c(  0.0 ), c(  0.0 ), c(  0.0 ), c(  1.0 )  &
    /)

    complex*8 :: B(stride_b*batch_size) = (/ &
        c( 5.0 ), c(  3.6 ), c( -2.2 ), c(  0.8 ), c( -3.4 )  &
                                                            , &
        c( 1.8 ), c( -0.6 ), c(  0.2 ), c( -0.6 ), c(  1.0 )  &
    /)

    real :: X(n*batch_size) = (/ &
        s( 1.0 ), s(  1.0 ), s(  1.0 ), s(  1.0 ), s(  1.0 )  &
                                                            , &
        s( 1.0 ), s(  1.0 ), s(  1.0 ), s(  1.0 ), s(  1.0 )  &
    /)

    integer :: info(batch_size) = -1

    !$omp target data map(A, B, info)
    !$omp dispatch
    call cgels_batch_strided('N', m, n, nrhs, A, lda, stride_a, B, ldb, stride_b, batch_size, info)
    !$omp end target data

    if (count(info/=0)) then
        print '("ERROR: Calculations failed with non-zeroes in info array:")'
        print '(*(I4))', info
        stop 1
    end if

    num_errors = 0
    print '("Results:")'
    do i = 1, stride_b*batch_size, stride_b
        print '(*(G11.4))', B(i:i+n-1)
        do j = 1, n
            if ((isnan(real(B(i+j-1)*B(i+j-1)))).or.(abs(B(i+j-1)-X(i+j-1))).gt.(1e-6)) then
                num_errors = num_errors+1
            end if
        end do
    end do

    if (num_errors.gt.0) then
        print '("ERROR: results mismatch!")'
        print '("Expected:")'
        do i = 1, batch_size
            print '(*(G11.4))', real(X((i-1)*n+1:i*n))
        end do
        stop 1
    else
        print '("Calculations successfully finished")'
    end if

end program
