<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt"
    exclude-result-prefixes="msxsl"
    xmlns:exsl="http://exslt.org/common"
    exsl:keep_exsl_namespace=""
    syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
  <root>
    <xsl:variable name="pmuConditions" select="document('config://include/pmu_variables.xsl')"/>
    <xsl:variable name="isSupportedPMU" select="$pmuConditions//variables/isSupportedPMU"/>
    <pmu_prerequisites>
      <xsl:if test="exsl:ctx('PMU', '') = ''">
        <xsl:value-of select="exsl:error('%UnknownPMUForAT')"/>
      </xsl:if>
      <xsl:if test="$isSupportedPMU = 'false'">
        <xsl:value-of select="exsl:error('%ThisAnalysisTypeIsNotApplicable')"/>
      </xsl:if>
    </pmu_prerequisites>
  </root>
 </xsl:template>
</xsl:stylesheet>
