#
# Copyright (C) 2020 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain the memory objects info for gpu row (only
# possible if GPU profile was collected).
#

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)


# Traverse the tree and print the entries.
# You can specify the GPU dataset of interest:
# `advisor.GpuDataType.BASIC` or `advisor.GpuDataType.ROOFLINE`,
# for which rows memory objects will be printed. 
# For example, gpu_rows = data.get_gpu_rows(advisor.GpuDataType.ROOFLINE)
# Note: accessing the `data.gpu` property is equivalent to calling the method
# `data.get_gpu_rows(advisor.GpuDataType.BASIC)`.
for top_level_row in data.gpu:
    stack = [(top_level_row, 0)]
    while stack:
        row, level = stack.pop()
        for c in row.children:
            stack.append((c, level + 1))

        print("Kernel: {}".format(row['computing_task']))
        for mem_obj in row.memory_objects:
            print(mem_obj)
