#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example is similar to sel-td.py; however, the difference is that it
# operates from the bottomup data set opposed to the topdown tree traversal.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir [comma-separated-column-list]"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
survey = project.load(advisor.SURVEY)

keys = ["function_call_sites_and_loops"]
if len(sys.argv) > 2:
    keys += sys.argv[2].split(",")

# Iterate the data in the bottomup table, then pretty-print it.
lenghts = {key: len(key) for key in keys}
for row in survey.bottomup:
    for key in keys:
        lenghts[key] = max(lenghts[key], len(row[key]))

fmt = ""
for key in keys:
    fmt += "{:<" + str(max(lenghts[key], 12)) + "} "
print(fmt.format(*keys))
for row in survey.bottomup:
    print(fmt.format(*[row[key] for key in keys]))
